/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.lang.reflect.Fields;

public class ThreadLocals {
    public static ThreadLocal getThreadLocal(String clsname, String fldname) {
        try {
            Class cls = Classes.forNameByThread((String)clsname);
            return ThreadLocals.getThreadLocal(cls, fldname);
        }
        catch (ClassNotFoundException ex) {
            throw SystemException.Aide.wrap((Throwable)ex);
        }
    }

    public static ThreadLocal getThreadLocal(Class cls, String fldname) {
        Field fld = null;
        boolean acs = false;
        try {
            fld = cls.getDeclaredField(fldname);
            acs = fld.isAccessible();
            fld.setAccessible(true);
            ThreadLocal threadLocal = (ThreadLocal)fld.get(cls);
            return threadLocal;
        }
        catch (NoSuchFieldException ex) {
            throw SystemException.Aide.wrap((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw SystemException.Aide.wrap((Throwable)ex);
        }
        finally {
            if (fld != null) {
                Fields.setAccessible((AccessibleObject)fld, (boolean)acs);
            }
        }
    }
}

