/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.zkoss.spring.security.config.ZkDesktopReuseFilter;
import org.zkoss.spring.security.config.ZkEventProcessDefinitionSourceBeanDefinitionParser;
import org.zkoss.spring.security.intercept.zkevent.EventProcessKey;
import org.zkoss.spring.security.intercept.zkevent.ZkEventProcessDefinitionSourceImpl;
import org.zkoss.spring.security.intercept.zkevent.ZkEventProcessInterceptor;
import org.zkoss.spring.security.ui.ZkAccessDeniedHandler;
import org.zkoss.spring.security.ui.ZkDisableSessionInvalidateFilter;
import org.zkoss.spring.security.ui.ZkEnableSessionInvalidateFilter;
import org.zkoss.spring.security.ui.ZkError403Filter;
import org.zkoss.spring.security.ui.ZkExceptionTranslationFilter;
import org.zkoss.spring.security.ui.ZkLoginOKFilter;
import org.zkoss.spring.security.ui.webapp.ZkAuthenticationEntryPoint;

public class ZkEventSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATT_PATH_TYPE = "path-type";
    public static final String DEF_PATH_TYPE_ANT = "ant";
    public static final String OPT_PATH_TYPE_REGEX = "regex";
    public static final String ATT_PATH = "path";
    public static final String ATT_ZK_EVENT = "event";
    public static final String ATT_ACCESS_CONFIG = "access";
    public static final String ATT_LOGIN_TEMPLATE = "login-template";
    public static final String ATT_LOGIN_TEMPLATE_CLOSE_DELAY = "login-template-close-delay";
    public static final String ATT_ERROR_TEMPLATE = "error-template";
    public static final String ATT_TITLE = "title";
    public static final String ATT_WIDTH = "width";
    public static final String ATT_HEIGHT = "height";
    public static final String ATT_LOGIN_PAGE = "login-page";
    public static final String ATT_LOGIN_OK_URL = "login-ok-url";
    public static final String ATT_AUTHENTICATION_FAILURE_URL = "authentication-failure-url";
    public static final String ATT_FORCE_HTTPS = "force-https";

    public BeanDefinition parse(Element element, ParserContext pc) {
        this.addHttpFilter(pc, "zkDesktopReuseFilter", ZkDesktopReuseFilter.class);
        this.addHttpFilter(pc, "zkDisableSessionInvalidateFilter", ZkDisableSessionInvalidateFilter.class);
        this.addHttpFilter(pc, "zkEnableSessionInvalidateFilter", ZkEnableSessionInvalidateFilter.class);
        this.registerLoginOKFilter(element, pc);
        this.registerZkError403Filter(element, pc);
        this.registerExceptionTranslationFilter(element, pc);
        this.registerZkEventProcessInterceptor(element, pc);
        return null;
    }

    private RootBeanDefinition addHttpFilter(ParserContext pc, String beanid, Class cls) {
        RootBeanDefinition rbd = new RootBeanDefinition(cls);
        pc.getRegistry().registerBeanDefinition(beanid, (BeanDefinition)rbd);
        return rbd;
    }

    private void registerLoginOKFilter(Element element, ParserContext pc) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ZkLoginOKFilter.class);
        RootBeanDefinition formLoginFilter = null;
        formLoginFilter = this.getStandardFilter(pc, UsernamePasswordAuthenticationFilter.class.getName());
        if (formLoginFilter != null) {
            RootBeanDefinition failureHandler;
            String authenticationFailureUrl;
            Object authFailureHandler;
            PropertyValue afUrl;
            RootBeanDefinition successHandler;
            String defaultTargetUrl;
            Object authSuccessHandler;
            PropertyValue dtUrl = formLoginFilter.getPropertyValues().getPropertyValue("authenticationSuccessHandler");
            if (dtUrl != null && (authSuccessHandler = dtUrl.getValue()) != null && authSuccessHandler instanceof RootBeanDefinition && StringUtils.hasText((String)(defaultTargetUrl = (String)(successHandler = (RootBeanDefinition)authSuccessHandler).getPropertyValues().getPropertyValue("defaultTargetUrl").getValue()))) {
                builder.addPropertyValue("defaultTargetUrl", (Object)defaultTargetUrl);
            }
            if ((afUrl = formLoginFilter.getPropertyValues().getPropertyValue("authenticationFailureHandler")) != null && (authFailureHandler = afUrl.getValue()) != null && authFailureHandler instanceof RootBeanDefinition && StringUtils.hasText((String)(authenticationFailureUrl = (String)(failureHandler = (RootBeanDefinition)authFailureHandler).getPropertyValues().getPropertyValue("defaultFailureUrl").getValue()))) {
                builder.addPropertyValue("authenticationFailureUrl", (Object)authenticationFailureUrl);
            }
        }
        pc.getRegistry().registerBeanDefinition("zkLoginOKFilter", (BeanDefinition)builder.getBeanDefinition());
    }

    private RootBeanDefinition getStandardFilter(ParserContext pc, String filterClassName) {
        RootBeanDefinition filterChainProxy = (RootBeanDefinition)pc.getRegistry().getBeanDefinition("org.springframework.security.filterChainProxy");
        PropertyValue v = filterChainProxy.getPropertyValues().getPropertyValue("filterChainMap");
        RootBeanDefinition standardFilter = null;
        if (v != null) {
            ManagedMap m = (ManagedMap)v.getValue();
            Set k = m.keySet();
            Iterator iterator = k.iterator();
            block0: while (iterator.hasNext()) {
                Object o = m.get(iterator.next());
                if (!(o instanceof List)) continue;
                List ml = (List)o;
                for (Object object : ml) {
                    String beanRefBeanName;
                    if (object instanceof RootBeanDefinition) {
                        RootBeanDefinition bean = (RootBeanDefinition)object;
                        String beanClassName = bean.getBeanClassName();
                        if (!beanClassName.equals(filterClassName)) continue;
                        standardFilter = bean;
                        continue block0;
                    }
                    if (!(object instanceof RuntimeBeanReference) || (beanRefBeanName = ((RuntimeBeanReference)object).getBeanName()).indexOf(filterClassName) == -1) continue;
                    standardFilter = (RootBeanDefinition)pc.getRegistry().getBeanDefinition(beanRefBeanName);
                    continue block0;
                }
            }
        }
        return standardFilter;
    }

    private void registerZkError403Filter(Element element, ParserContext pc) {
        RootBeanDefinition handler;
        PropertyValue pv;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ZkError403Filter.class);
        RootBeanDefinition exceptionTranslationFilter = this.getStandardFilter(pc, ExceptionTranslationFilter.class.getName());
        if (exceptionTranslationFilter != null && (pv = exceptionTranslationFilter.getPropertyValues().getPropertyValue("accessDeniedHandler")) != null && (handler = (RootBeanDefinition)pv.getValue()) != null && handler instanceof RootBeanDefinition) {
            builder.addPropertyValue("accessDeniedHandler", (Object)handler);
        }
        pc.getRegistry().registerBeanDefinition("zkError403Filter", (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerExceptionTranslationFilter(Element element, ParserContext pc) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ZkExceptionTranslationFilter.class);
        ZkAccessDeniedHandler accessDeniedHandler = new ZkAccessDeniedHandler();
        builder.addPropertyValue("accessDeniedHandler", (Object)accessDeniedHandler);
        ZkAuthenticationEntryPoint entryPoint = new ZkAuthenticationEntryPoint();
        String closeDelay = element.getAttribute(ATT_LOGIN_TEMPLATE_CLOSE_DELAY);
        if (StringUtils.hasText((String)closeDelay)) {
            int seconds = new Integer(closeDelay);
            entryPoint.setLoginOKDelay(seconds);
        }
        this.setEntryPointAttrs(entryPoint, element, pc);
        builder.addPropertyValue("authenticationEntryPoint", (Object)entryPoint);
        pc.getRegistry().registerBeanDefinition("zkExceptionTranslationFilter", (BeanDefinition)builder.getBeanDefinition());
    }

    private void setEntryPointAttrs(ZkAuthenticationEntryPoint entryPoint, Element rootElm, ParserContext pc) {
        String httpForceHttps;
        PropertyValue pv;
        String forceHttps;
        String loginFormUrl;
        String loginPage;
        String height;
        String width;
        String title;
        PropertyValue pv2;
        Element element = DomUtils.getChildElementByTagName((Element)rootElm, (String)"form-login");
        RootBeanDefinition exceptionTranslationFilter = this.getStandardFilter(pc, ExceptionTranslationFilter.class.getName());
        RootBeanDefinition formEntryPoint = null;
        if (exceptionTranslationFilter != null && (pv2 = exceptionTranslationFilter.getPropertyValues().getPropertyValue("authenticationEntryPoint")) != null) {
            formEntryPoint = (RootBeanDefinition)pv2.getValue();
        }
        if (element == null) {
            if (formEntryPoint != null) {
                String httpForceHttps2;
                PropertyValue pv3;
                String loginFormUrl2 = (String)formEntryPoint.getPropertyValues().getPropertyValue("loginFormUrl").getValue();
                if (StringUtils.hasText((String)loginFormUrl2)) {
                    entryPoint.setLoginFormUrl(loginFormUrl2);
                    entryPoint.setLoginFailUrl(loginFormUrl2);
                }
                if ((pv3 = formEntryPoint.getPropertyValues().getPropertyValue("forceHttps")) != null && StringUtils.hasText((String)(httpForceHttps2 = (String)pv3.getValue()))) {
                    entryPoint.setForceHttps("true".equals(httpForceHttps2));
                }
            }
            return;
        }
        String loginOKUrl = element.getAttribute(ATT_LOGIN_OK_URL);
        WebConfigUtils.validateHttpRedirect((String)loginOKUrl, (ParserContext)pc, (Object)pc.extractSource((Object)element));
        if (StringUtils.hasText((String)loginOKUrl)) {
            entryPoint.setLoginOKUrl(loginOKUrl);
        }
        String loginFailUrl = element.getAttribute(ATT_AUTHENTICATION_FAILURE_URL);
        WebConfigUtils.validateHttpRedirect((String)loginFailUrl, (ParserContext)pc, (Object)pc.extractSource((Object)element));
        if (StringUtils.hasText((String)loginFailUrl)) {
            entryPoint.setLoginFailUrl(loginFailUrl);
        }
        if (StringUtils.hasText((String)(title = element.getAttribute(ATT_TITLE)))) {
            entryPoint.setLoginTemplateArg(ATT_TITLE, title);
        }
        if (StringUtils.hasText((String)(width = element.getAttribute(ATT_WIDTH)))) {
            entryPoint.setLoginTemplateArg(ATT_WIDTH, width);
        }
        if (StringUtils.hasText((String)(height = element.getAttribute(ATT_HEIGHT)))) {
            entryPoint.setLoginTemplateArg(ATT_HEIGHT, height);
        }
        if (StringUtils.hasText((String)(loginPage = element.getAttribute(ATT_LOGIN_PAGE)))) {
            entryPoint.setLoginFormUrl(loginPage);
            if (!StringUtils.hasText((String)loginFailUrl)) {
                entryPoint.setLoginFailUrl(loginPage + "?login_error=true");
            }
        } else if (formEntryPoint != null && StringUtils.hasText((String)(loginFormUrl = (String)formEntryPoint.getPropertyValues().getPropertyValue("loginFormUrl").getValue()))) {
            entryPoint.setLoginFormUrl(loginFormUrl);
            if (!StringUtils.hasText((String)loginFailUrl)) {
                entryPoint.setLoginFailUrl(loginFormUrl);
            }
        }
        if (StringUtils.hasText((String)(forceHttps = element.getAttribute(ATT_FORCE_HTTPS)))) {
            entryPoint.setForceHttps("true".equals(forceHttps));
        } else if (formEntryPoint != null && (pv = formEntryPoint.getPropertyValues().getPropertyValue("forceHttps")) != null && StringUtils.hasText((String)(httpForceHttps = (String)pv.getValue()))) {
            entryPoint.setForceHttps("true".equals(httpForceHttps));
        }
    }

    private void registerZkEventProcessInterceptor(Element element, ParserContext pc) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ZkEventProcessInterceptor.class);
        List eventElms = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-event");
        LinkedHashMap<EventProcessKey, Collection<ConfigAttribute>> requestMap = ZkEventProcessDefinitionSourceBeanDefinitionParser.parseInterceptEventsForZkEventProcessMap(eventElms, pc);
        RootBeanDefinition interceptor = this.getStandardFilter(pc, FilterSecurityInterceptor.class.getName());
        Object accessDecisionManager = interceptor.getPropertyValues().getPropertyValue("accessDecisionManager").getValue();
        Object authenticationManager = interceptor.getPropertyValues().getPropertyValue("authenticationManager").getValue();
        UrlMatcher matcher = ZkEventSecurityBeanDefinitionParser.createUrlMatcher(element);
        builder.addPropertyValue("accessDecisionManager", accessDecisionManager);
        builder.addPropertyValue("authenticationManager", authenticationManager);
        builder.addPropertyValue("objectDefinitionSource", (Object)new ZkEventProcessDefinitionSourceImpl(matcher, requestMap));
        pc.getRegistry().registerBeanDefinition("zkEventProcessInterceptor", (BeanDefinition)builder.getBeanDefinition());
    }

    public static UrlMatcher createUrlMatcher(Element element) {
        String pathType = element.getAttribute(ATT_PATH_TYPE);
        if (!StringUtils.hasText((String)pathType)) {
            pathType = DEF_PATH_TYPE_ANT;
        }
        if (pathType.equals(OPT_PATH_TYPE_REGEX)) {
            RegexUrlPathMatcher matcher = new RegexUrlPathMatcher();
            matcher.setRequiresLowerCaseUrl(false);
            return matcher;
        }
        AntUrlPathMatcher matcher = new AntUrlPathMatcher();
        matcher.setRequiresLowerCaseUrl(false);
        return matcher;
    }
}

