/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.init;

import javax.servlet.ServletContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.zkoss.lang.Library;
import org.zkoss.spring.DelegatingVariableResolver;
import org.zkoss.spring.security.config.ZkSecurityContextListener;
import org.zkoss.spring.security.intercept.zkevent.ZkEventProcessListener;
import org.zkoss.spring.security.ui.ZkExceptionTranslationListener;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.WebAppInit;

public class SecurityWebAppInit
implements WebAppInit {
    private static String RESOLVER_CLASS = DelegatingVariableResolver.RESOLVER_CLASS;
    private static String SECURITY_RESOLVER = "org.zkoss.spring.init.SecurityVariableResolver";

    public void init(WebApp wapp) throws Exception {
        String classes;
        Configuration conf = wapp.getConfiguration();
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((ServletContext)wapp.getNativeContext()));
        if (ctx.containsBeanDefinition("zkDesktopReuseFilter")) {
            conf.addListener(ZkSecurityContextListener.class);
            conf.addListener(ZkExceptionTranslationListener.class);
            conf.addListener(ZkEventProcessListener.class);
        }
        if ((classes = Library.getProperty((String)RESOLVER_CLASS)) == null) {
            Library.setProperty((String)RESOLVER_CLASS, (String)SECURITY_RESOLVER);
        } else {
            Library.setProperty((String)RESOLVER_CLASS, (String)(classes + "," + SECURITY_RESOLVER));
        }
    }
}

