/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.zkoss.spring.SpringUtil;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtil {
    private static AclService _aclService;
    private static ApplicationContext _applicationContext;
    private static ObjectIdentityRetrievalStrategy _objectIdentityRetrievalStrategy;
    private static SidRetrievalStrategy _sidRetrievalStrategy;
    private static PermissionFactory permissionFactory;

    public static boolean isAccessible(String hasPermission, Object domainObject) {
        if (hasPermission == null || "".equals(hasPermission)) {
            return false;
        }
        SecurityUtil.initializeIfRequired();
        List<Permission> requiredPermissions = SecurityUtil.parsePermissions(hasPermission);
        Object resolvedDomainObject = domainObject;
        if (resolvedDomainObject == null) {
            return true;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return false;
        }
        List sids = _sidRetrievalStrategy.getSids(SecurityContextHolder.getContext().getAuthentication());
        ObjectIdentity oid = _objectIdentityRetrievalStrategy.getObjectIdentity(resolvedDomainObject);
        try {
            Acl acl = _aclService.readAclById(oid, sids);
            return acl.isGranted(requiredPermissions, sids, false);
        }
        catch (NotFoundException nfe) {
            return false;
        }
    }

    public static boolean isNoneGranted(String authorities) {
        if (null == authorities || "".equals(authorities)) {
            return false;
        }
        Collection<GrantedAuthority> granted = SecurityUtil.getPrincipalAuthorities();
        Set grantedCopy = SecurityUtil.retainAll(granted, SecurityUtil.parseAuthoritiesString(authorities));
        return grantedCopy.isEmpty();
    }

    public static boolean isAllGranted(String authorities) {
        if (null == authorities || "".equals(authorities)) {
            return false;
        }
        Collection<GrantedAuthority> granted = SecurityUtil.getPrincipalAuthorities();
        boolean isAllGranted = granted.containsAll(SecurityUtil.parseAuthoritiesString(authorities));
        return isAllGranted;
    }

    public static boolean isAnyGranted(String authorities) {
        if (null == authorities || "".equals(authorities)) {
            return false;
        }
        Collection<GrantedAuthority> granted = SecurityUtil.getPrincipalAuthorities();
        Set grantedCopy = SecurityUtil.retainAll(granted, SecurityUtil.parseAuthoritiesString(authorities));
        return !grantedCopy.isEmpty();
    }

    public static Authentication getAuthentication() {
        Authentication auth;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext() instanceof SecurityContext && (auth = SecurityContextHolder.getContext().getAuthentication()) != null && auth.getPrincipal() != null) {
            return auth;
        }
        return null;
    }

    public static Object getAuthentication(String property) {
        if (property != null) {
            if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
                return null;
            }
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth.getPrincipal() == null) {
                return null;
            }
            try {
                BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)auth);
                return wrapper.getPropertyValue(property);
            }
            catch (BeansException e) {
                throw new UiException((Throwable)e);
            }
        }
        return null;
    }

    private static List<Permission> parsePermissions(String permissionsString) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(permissionsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String permission = tokenizer.nextToken();
            try {
                permissions.add(permissionFactory.buildFromMask(Integer.valueOf(permission).intValue()));
            }
            catch (NumberFormatException nfe) {
                permissions.add(permissionFactory.buildFromName(permission));
            }
        }
        return new ArrayList<Permission>(permissions);
    }

    private static void initializeIfRequired() {
        if (_applicationContext != null) {
            return;
        }
        _applicationContext = SpringUtil.getApplicationContext();
        Map map = new HashMap();
        for (ApplicationContext context = _applicationContext; context != null; context = context.getParent()) {
            map.putAll(context.getBeansOfType(AclService.class));
        }
        if (map.size() != 1) {
            throw new UiException("Found incorrect number of AclService instances in application context - you must have only have one!");
        }
        _aclService = (AclService)map.values().iterator().next();
        map = _applicationContext.getBeansOfType(SidRetrievalStrategy.class);
        if (map.size() == 0) {
            _sidRetrievalStrategy = new SidRetrievalStrategyImpl();
        } else if (map.size() == 1) {
            _sidRetrievalStrategy = (SidRetrievalStrategy)map.values().iterator().next();
        } else {
            throw new UiException("Found incorrect number of SidRetrievalStrategy instances in application context - you must have only have one!");
        }
        map = _applicationContext.getBeansOfType(ObjectIdentityRetrievalStrategy.class);
        if (map.size() == 0) {
            _objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
        } else if (map.size() == 1) {
            _objectIdentityRetrievalStrategy = (ObjectIdentityRetrievalStrategy)map.values().iterator().next();
        } else {
            throw new UiException("Found incorrect number of ObjectIdentityRetrievalStrategy instances in application context - you must have only have one!");
        }
    }

    private static Set authoritiesToRoles(Collection c) {
        HashSet<String> target = new HashSet<String>();
        for (GrantedAuthority authority : c) {
            if (null == authority.getAuthority()) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + authority.toString());
            }
            target.add(authority.getAuthority());
        }
        return target;
    }

    private static Collection<GrantedAuthority> getPrincipalAuthorities() {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (null == currentUser) {
            return Collections.emptyList();
        }
        if (null == currentUser.getAuthorities() || currentUser.getAuthorities().size() < 1) {
            return Collections.emptyList();
        }
        Collection granted = currentUser.getAuthorities();
        return granted;
    }

    private static Collection<GrantedAuthority> parseAuthoritiesString(String authorizationsString) {
        ArrayList<GrantedAuthority> requiredAuthorities = new ArrayList<GrantedAuthority>();
        String[] roles = authorizationsString.split(",");
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].trim();
            requiredAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl(role));
        }
        return requiredAuthorities;
    }

    private static Set retainAll(Collection<GrantedAuthority> granted, Collection<GrantedAuthority> required) {
        Set grantedRoles = SecurityUtil.authoritiesToRoles(granted);
        Set requiredRoles = SecurityUtil.authoritiesToRoles(required);
        grantedRoles.retainAll(requiredRoles);
        return SecurityUtil.rolesToAuthorities(grantedRoles, granted);
    }

    private static Set rolesToAuthorities(Set grantedRoles, Collection granted) {
        HashSet<GrantedAuthority> target = new HashSet<GrantedAuthority>();
        block0: for (String role : grantedRoles) {
            for (GrantedAuthority authority : granted) {
                if (!authority.getAuthority().equals(role)) continue;
                target.add(authority);
                continue block0;
            }
        }
        return target;
    }
}

