/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.config;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.filter.GenericFilterBean;
import org.zkoss.spring.impl.ZKProxy;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class ZkDesktopReuseFilter
extends GenericFilterBean
implements ServletContextAware {
    static final String ATTR_DESKTOP = "javax.zkoss.zk.ui.desktop";
    static final String FILTER_APPLIED = "__zk_spring_desktop_reuse_filter_applied";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private WebApp _webApp;
    private ServletContext _ctx;

    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession hsess;
        String dtid;
        Desktop desktop;
        if (((HttpServletRequest)request).getSession(false) == null || request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        if (this._webApp == null) {
            WebManager webman = WebManager.getWebManager((ServletContext)((HttpServletRequest)request).getSession(false).getServletContext());
            this._webApp = webman.getWebApp();
        }
        if ((desktop = (Desktop)request.getAttribute(ATTR_DESKTOP)) == null && (dtid = request.getParameter("dt")) != null && (hsess = ((HttpServletRequest)request).getSession(false)) != null && hsess.getAttribute(dtid) != null) {
            Desktop olddesktop;
            DesktopCache cache;
            hsess.removeAttribute(dtid);
            Session sess = ((WebAppCtrl)this._webApp).getSessionCache().get((Object)hsess);
            if (sess != null && (cache = ((WebAppCtrl)this._webApp).getDesktopCache(sess)) != null && (olddesktop = cache.getDesktopIfAny(dtid)) != null) {
                request.setAttribute(ATTR_DESKTOP, (Object)olddesktop);
                ZKProxy.getProxy().responseSent((DesktopCtrl)olddesktop, "au", "", (Object)Boolean.TRUE);
                request.setAttribute("zkoss.spring.DESKTOP_REUSE", (Object)Boolean.TRUE);
            }
        }
        chain.doFilter(request, response);
    }
}

