/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.config;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.ConfigAttributeEditor;
import org.springframework.security.config.http.ZkEventSecurityBeanDefinitionParser;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.zkoss.spring.security.intercept.zkevent.EventProcessKey;
import org.zkoss.spring.security.intercept.zkevent.ZkEventProcessDefinitionSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZkEventProcessDefinitionSourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<ZkEventProcessDefinitionSourceImpl> getBeanClass(Element element) {
        return ZkEventProcessDefinitionSourceImpl.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List interceptUrls = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-event");
        UrlMatcher matcher = ZkEventSecurityBeanDefinitionParser.createUrlMatcher(element);
        LinkedHashMap<EventProcessKey, Collection<ConfigAttribute>> requestMap = ZkEventProcessDefinitionSourceBeanDefinitionParser.parseInterceptEventsForZkEventProcessMap(interceptUrls, parserContext);
        builder.addConstructorArgValue((Object)matcher);
        builder.addConstructorArgValue(requestMap);
    }

    public static LinkedHashMap<EventProcessKey, Collection<ConfigAttribute>> parseInterceptEventsForZkEventProcessMap(List elms, ParserContext parserContext) {
        LinkedHashMap<EventProcessKey, Collection<ConfigAttribute>> eventProcessDefinitionMap = new LinkedHashMap<EventProcessKey, Collection<ConfigAttribute>>();
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        for (Element elm : elms) {
            String access;
            String event;
            String path = elm.getAttribute("path");
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)elm);
            }
            if (!StringUtils.hasText((String)(event = elm.getAttribute("event")))) {
                event = null;
            }
            if (!StringUtils.hasText((String)(access = elm.getAttribute("access")))) continue;
            editor.setAsText(access);
            eventProcessDefinitionMap.put(new EventProcessKey(path, event), (Collection)editor.getValue());
        }
        return eventProcessDefinitionMap;
    }
}

