/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.config;

import java.util.List;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;

public class ZkSecurityContextListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private SecurityContext _ctx;
    private final boolean _enabled;

    public ZkSecurityContextListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._enabled = app.getConfiguration().isEventThreadEnabled();
    }

    public void prepare(Component comp, Event event) throws Exception {
        if (this._enabled) {
            this._ctx = SecurityContextHolder.getContext();
        }
    }

    public boolean init(Component comp, Event event) throws Exception {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._ctx);
        }
        return true;
    }

    public void cleanup(Component comp, Event evt, List errs) throws Exception {
        if (this._enabled) {
            this._ctx = SecurityContextHolder.getContext();
        }
    }

    public void complete(Component comp, Event evt) throws Exception {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._ctx);
        }
    }

    public void beforeResume(Component comp, Event evt) throws Exception {
        if (this._enabled) {
            this._ctx = SecurityContextHolder.getContext();
        }
    }

    public void afterResume(Component comp, Event evt) throws Exception {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._ctx);
        }
    }

    public void abortResume(Component comp, Event evt) throws Exception {
    }
}

