/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.intercept.zkevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.util.UrlMatcher;
import org.zkoss.spring.security.intercept.zkevent.EventProcessKey;
import org.zkoss.spring.security.intercept.zkevent.ZkEventProcessDefinitionSource;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZkEventProcessDefinitionSourceImpl
implements ZkEventProcessDefinitionSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlMatcher _pathMatcher;
    private Map _eventMap = new LinkedHashMap();

    public ZkEventProcessDefinitionSourceImpl(UrlMatcher pathMatcher) {
        this._pathMatcher = pathMatcher;
    }

    public ZkEventProcessDefinitionSourceImpl(UrlMatcher pathMatcher, LinkedHashMap requestMap) {
        this._pathMatcher = pathMatcher;
        for (Map.Entry entry : requestMap.entrySet()) {
            EventProcessKey key = (EventProcessKey)entry.getKey();
            this.addSecureEvent(key.getPath(), key.getEvent(), (Collection)entry.getValue());
        }
    }

    public void addSecureEvent(String path, String event, Collection<ConfigAttribute> attr) {
        Map mapToUse = this.getPathMapForEvent(event);
        mapToUse.put(this._pathMatcher.compile(path), attr);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added ZK component path pattern: " + path + "; attributes: " + attr + (event == null ? "" : " for event '" + event + "'")));
        }
    }

    private Map getPathMapForEvent(String event) {
        if (event == null || "*".equals(event)) {
            event = "on*";
        }
        if (!event.startsWith("on")) {
            throw new IllegalArgumentException("Unrecognised event: '" + event + "'");
        }
        LinkedHashMap pathmap = (LinkedHashMap)this._eventMap.get(event);
        if (pathmap == null) {
            pathmap = new LinkedHashMap();
            this._eventMap.put(event, pathmap);
        }
        return pathmap;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be an Event");
        }
        Component comp = ((Event)object).getTarget();
        String path = this.toPath(comp, new StringBuffer()).toString();
        String eventnm = ((Event)object).getName();
        return this.lookupAttributes(path, eventnm);
    }

    private StringBuffer toPath(Object comp, StringBuffer sb) {
        if (comp instanceof Page) {
            sb.append("//").append(((Page)comp).getId());
        } else {
            Component xcomp = (Component)comp;
            IdSpace spaceOwner = null;
            if (xcomp instanceof IdSpace) {
                Component parent = xcomp.getParent();
                spaceOwner = parent == null ? xcomp.getPage() : parent.getSpaceOwner();
            } else if (xcomp != null) {
                spaceOwner = xcomp.getSpaceOwner();
            } else {
                sb.append("null");
                return sb;
            }
            this.toPath(spaceOwner, sb);
            sb.append('/').append(xcomp.getId());
        }
        return sb;
    }

    public Collection<ConfigAttribute> lookupAttributes(String path, String event) {
        Collection<ConfigAttribute> attributes = null;
        Map pathMap = (Map)this._eventMap.get(event);
        if (pathMap != null) {
            attributes = this.lookupPathInMap(pathMap, path, event);
        }
        if (attributes == null && (pathMap = (Map)this._eventMap.get("on*")) != null) {
            attributes = this.lookupPathInMap(pathMap, path, event);
        }
        return attributes;
    }

    private Collection<ConfigAttribute> lookupPathInMap(Map pathMap, String path, String event) {
        for (Map.Entry entry : pathMap.entrySet()) {
            Object pattern = entry.getKey();
            boolean matched = this._pathMatcher.pathMatchesUrl(pattern, path);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Candidate ZK component is: '" + path + "'; event is: '" + event + "'; path pattern is " + pattern + "; matched=" + matched));
            }
            if (!matched) continue;
            return (Collection)entry.getValue();
        }
        return null;
    }

    public Collection getConfigAttributeDefinitions() {
        ArrayList list = new ArrayList();
        for (Map pathMap : this._eventMap.values()) {
            list.addAll(pathMap.values());
        }
        return list;
    }

    public boolean supports(Class clazz) {
        return Event.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }
}

