/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.zkoss.zk.ui.Executions;

public class ZkAccessDeniedHandler
implements AccessDeniedHandler {
    private Map _errorTemplateArgs = new HashMap();
    private String _errorTemplate;
    public static final String ERROR_403_URL = "/zk_error_403";
    private static final String DEFAULT_ERROR_TEMPLATE = "~./zul/zkspring/security/errorTemplate.zul";

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        String template = this.getErrorTemplate();
        HashMap<String, Object> args = new HashMap<String, Object>(this.getErrorTemplateArgs());
        args.put("SPRING_SECURITY_403_EXCEPTION", accessDeniedException);
        args.put("errorUrl", ERROR_403_URL);
        Executions.createComponents((String)(template == null || template.trim().length() == 0 ? DEFAULT_ERROR_TEMPLATE : template), null, args);
    }

    public void setErrorTemplateArg(String param, Object value) {
        this._errorTemplateArgs.put(param, value);
    }

    public void removeErrorTemplateArg(String param) {
        this._errorTemplateArgs.remove(param);
    }

    public void setErrorTemplateArgs(Map map) {
        this._errorTemplateArgs = map;
    }

    public Map getErrorTemplateArgs() {
        return this._errorTemplateArgs;
    }

    public void setErrorTemplate(String templateURL) {
        this._errorTemplate = templateURL;
    }

    public String getErrorTemplate() {
        return this._errorTemplate;
    }
}

