/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.web.filter.GenericFilterBean;

public class ZkError403Filter
extends GenericFilterBean {
    private AccessDeniedHandler _accessDeniedHandler = new AccessDeniedHandlerImpl();

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
    }

    public void setAccessDeniedHandler(AccessDeniedHandler handler) {
        this._accessDeniedHandler = handler;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession sess = ((HttpServletRequest)request).getSession(false);
        if (sess == null) {
            chain.doFilter(request, response);
            return;
        }
        AccessDeniedException accessDeniedException = (AccessDeniedException)sess.getAttribute("SPRING_SECURITY_403_EXCEPTION");
        if (accessDeniedException != null) {
            String uri = ((HttpServletRequest)request).getRequestURI();
            String ctxpath = ((HttpServletRequest)request).getContextPath();
            boolean isError403 = (ctxpath + "/zk_error_403").equals(uri);
            if (isError403) {
                this._accessDeniedHandler.handle((HttpServletRequest)request, (HttpServletResponse)response, accessDeniedException);
                return;
            }
            request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
        }
        chain.doFilter(request, response);
    }
}

