/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.zkoss.lang.Exceptions;
import org.zkoss.spring.SpringUtil;
import org.zkoss.spring.impl.ZKProxy;
import org.zkoss.spring.security.ui.ZkExceptionTranslationFilter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class ZkExceptionTranslationListener
implements EventThreadCleanup {
    private static final String DEFAULT_EXCEPTION_TRANSLATION_FILTER_NAME = "zkExceptionTranslationFilter";
    public static final String ZK_EXCEPTION_TRANSLATION = "zkspring.ZK_EXCEPTION_TRANSLATION";

    public void cleanup(Component comp, Event evt, List errs) throws Exception {
        if (errs != null && !errs.isEmpty() && errs.size() == 1) {
            Throwable ex = (Throwable)errs.get(0);
            if (ex instanceof AuthenticationException) {
                ex = Exceptions.findCause((Throwable)ex, AuthenticationException.class);
            } else if (ex instanceof AccessDeniedException) {
                ex = Exceptions.findCause((Throwable)ex, AccessDeniedException.class);
            }
            if (ex == null) {
                // empty if block
            }
            if (ex != null) {
                errs.clear();
                ExecutionCtrl exectrl = (ExecutionCtrl)Executions.getCurrent();
                ArrayList<Event> evts = new ArrayList<Event>();
                do {
                    evts.add(evt);
                } while ((evt = exectrl.getNextEvent()) != null);
                ZKProxy.getProxy().setAttribute((Execution)exectrl, "ZKSPRING_SECURITY_EVENTS", evts);
                this.doExceptionTranslationFiltering(ex);
            }
        }
    }

    public void complete(Component comp, Event evt) throws Exception {
    }

    public void doExceptionTranslationFiltering(final Throwable ex) throws Exception {
        Execution exec = Executions.getCurrent();
        String name = DEFAULT_EXCEPTION_TRANSLATION_FILTER_NAME;
        ExceptionTranslationFilter filter = (ExceptionTranslationFilter)SpringUtil.getBean((String)DEFAULT_EXCEPTION_TRANSLATION_FILTER_NAME, ExceptionTranslationFilter.class);
        if (filter == null) {
            filter = new ZkExceptionTranslationFilter();
        }
        ZKProxy.getProxy().setAttribute(exec, ZK_EXCEPTION_TRANSLATION, (Object)Boolean.TRUE);
        filter.doFilter((ServletRequest)exec.getNativeRequest(), (ServletResponse)exec.getNativeResponse(), new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
                if (ex instanceof AuthenticationException) {
                    throw (AuthenticationException)ex;
                }
                if (ex instanceof AccessDeniedException) {
                    throw (AccessDeniedException)ex;
                }
                throw new RuntimeException(ex);
            }
        });
    }
}

