/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class ZkLoginOKFilter
extends GenericFilterBean {
    private AuthenticationTrustResolver _authResolver = new AuthenticationTrustResolverImpl();
    private String _defaultTargetUrl = "/";
    private String _authenticationFailureUrl;

    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
    }

    private String getFullPath(HttpServletRequest request) {
        String query;
        StringBuffer sb = new StringBuffer(request.getRequestURI());
        if (sb != null && sb.indexOf("zkau") != -1) {
            sb.delete(sb.indexOf("zkau"), sb.indexOf("zkau") + 4);
        }
        return ((query = request.getQueryString()) != null ? sb.append('?').append(query) : sb).toString();
    }

    public void setDefaultTargetUrl(String url) {
        this._defaultTargetUrl = url;
    }

    public void setAuthenticationFailureUrl(String url) {
        this._authenticationFailureUrl = url;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession sess = ((HttpServletRequest)request).getSession(false);
        if (sess == null) {
            chain.doFilter(request, response);
            return;
        }
        String loginOKUrl = (String)sess.getAttribute("ZKSPRING_SECURITY_LOGIN_OK_URL");
        if (loginOKUrl != null) {
            String loginFailUrl;
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String uri = this.getFullPath((HttpServletRequest)request);
            String ctxpath = ((HttpServletRequest)request).getContextPath();
            if (auth != null && auth.isAuthenticated() && !this._authResolver.isAnonymous(auth)) {
                sess.removeAttribute("ZKSPRING_SECURITY_LOGIN_OK_URL");
                if ((ctxpath + this._defaultTargetUrl).equals(uri)) {
                    String loginOKTemplate = (String)sess.getAttribute("ZKSPRING_SECURITY_LOGIN_OK_TEMPLATE");
                    if (loginOKTemplate == null) {
                        loginOKTemplate = "ZKSPRING_SECURITY_LOGIN_OK_TEMPLATE";
                    }
                    StringBuffer url = new StringBuffer(128);
                    url.append("?loginOKUrl=" + loginOKUrl);
                    url.append("&loginOKDelay=").append(sess.getAttribute("ZKSPRING_SECURITY_LOGIN_OK_DELAY"));
                    if (sess.getAttribute("ZKSPRING_SECURITY_FORCE_HTTPS") != null) {
                        url.append("&savedUrl=").append(sess.getAttribute("ZKSPRING_SECURITY_SAVED_URL"));
                        url.append("&desktop=").append(sess.getAttribute("ZKSPRING_SECURITY_SAVED_DESKTOP"));
                        url.append("&loginWin=").append(sess.getAttribute("ZKSPRING_SECURITY_LOGIN_WIN"));
                    }
                    HttpServletRequest httpRequest = (HttpServletRequest)request;
                    RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(loginOKTemplate + url);
                    dispatcher.forward(request, response);
                    return;
                }
            } else if ((ctxpath + this._authenticationFailureUrl).equals(uri) && (loginFailUrl = (String)sess.getAttribute("ZKSPRING_SECURITY_LOGIN_FAIL_URL")) != null) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(loginFailUrl);
                dispatcher.forward(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

