/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui.webapp;

import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.zkoss.spring.impl.ZKProxy;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.URIEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.GenericForwardComposer;

public class LoginTemplateComposer
extends GenericForwardComposer {
    private boolean _forceHttps;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.sessionScope.put("ZKSPRING_SECURITY_LOGIN_OK_URL", this.arg.get("loginOKUrl"));
        this.sessionScope.put("ZKSPRING_SECURITY_LOGIN_FAIL_URL", this.arg.get("loginFailUrl"));
        this.sessionScope.put("ZKSPRING_SECURITY_LOGIN_OK_TEMPLATE", this.arg.get("loginOKTemplate"));
        this.sessionScope.put("ZKSPRING_SECURITY_SAVED_URL", this.desktop.getAttribute("zkoss.spring.DESKTOP_URL"));
        this.sessionScope.put("ZKSPRING_SECURITY_SAVED_DESKTOP", this.desktop.getId());
        this.sessionScope.put("ZKSPRING_SECURITY_LOGIN_WIN", comp.getUuid());
        this.sessionScope.put("ZKSPRING_SECURITY_LOGIN_OK_DELAY", this.arg.get("loginOKDelay"));
        Boolean b = (Boolean)this.arg.get("forceHttps");
        boolean bl = this._forceHttps = b != null && b != false;
        if (this._forceHttps) {
            this.sessionScope.put("ZKSPRING_SECURITY_FORCE_HTTPS", Boolean.TRUE);
        }
    }

    public void onCreate() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            ZKProxy.getProxy().setAttribute(this.execution, "ZKSPRING_SECURITY_AUTH", (Object)auth);
        }
        if (this._forceHttps) {
            Clients.evalJavaScript((String)"zk.keepDesktop=true");
        }
        Collection roots = this.page.getRoots();
        for (Component root : roots) {
            if (root == this.spaceOwner) continue;
            Events.postEvent((Event)new Event("onLogin", root, (Object)auth));
        }
    }

    public void onRemoveLoginWin(Event event) {
        this.postLoginOK();
        event.getTarget().detach();
    }

    private void postLoginOK() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        ZKProxy.getProxy().setAttribute(this.execution, "ZKSPRING_SECURITY_AUTH", (Object)auth);
        Collection roots = this.page.getRoots();
        for (Component root : roots) {
            if (root == this.spaceOwner) continue;
            Events.postEvent((String)"onLoginOk", (Component)root, (Object)auth);
        }
    }

    public void onURIChange$loginfrm(URIEvent event) {
        Object loginOKUrl = Sessions.getCurrent().getAttribute("ZKSPRING_SECURITY_LOGIN_OK_URL");
        String closeUri = event.getURI();
        if (loginOKUrl == null && closeUri != null && closeUri.endsWith("/~./zul/zkspring/security/closePopup.zul")) {
            this.postLoginOK();
            this.self.detach();
        }
    }
}

