/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.spring.security.ui.webapp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.util.StringUtils;
import org.zkoss.zk.ui.Executions;

public class ZkAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private Map _loginTemplateArgs = new HashMap();
    private String _loginTemplate;
    private String _loginOKTemplate;
    private String _loginOKUrl;
    private String _loginFailUrl;
    private int _delay = 0;
    public static final String SPRING_SECURITY_SAVED_REQUEST_KEY = "SPRING_SECURITY_SAVED_REQUEST_KEY";
    public static final String LOGIN_OK_URL = "ZKSPRING_SECURITY_LOGIN_OK_URL";
    public static final String LOGIN_OK_TEMPLATE = "ZKSPRING_SECURITY_LOGIN_OK_TEMPLATE";
    public static final String LOGIN_FAIL_URL = "ZKSPRING_SECURITY_LOGIN_FAIL_URL";
    public static final String SAVED_URL = "ZKSPRING_SECURITY_SAVED_URL";
    public static final String SAVED_DESKTOP = "ZKSPRING_SECURITY_SAVED_DESKTOP";
    public static final String LOGIN_WIN = "ZKSPRING_SECURITY_LOGIN_WIN";
    public static final String FORCE_HTTPS = "ZKSPRING_SECURITY_FORCE_HTTPS";
    public static final String LOGIN_OK_DELAY = "ZKSPRING_SECURITY_LOGIN_OK_DELAY";
    public static final String EVENTS = "ZKSPRING_SECURITY_EVENTS";
    public static final String AUTH = "ZKSPRING_SECURITY_AUTH";
    private static final String DEFAULT_LOGIN_TEMPLATE = "~./zul/zkspring/security/loginTemplate.zul";
    private static final String DEFAULT_LOGIN_OK = "~./zul/zkspring/security/loginOK.zul";
    private static final String DEFAULT_LOGIN_OK_TEMPLATE = "~./zul/zkspring/security/loginOKTemplate.zul";

    public ZkAuthenticationEntryPoint() {
        this.setLoginFormUrl("/spring_security_login");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        String template = this.getLoginTemplate();
        String loginUrl = this.buildRedirectUrlToLoginPage(httpRequest, httpResponse, authException);
        String loginOKUrl = this.getLoginOKUrl() == null ? DEFAULT_LOGIN_OK : this.getLoginOKUrl();
        String loginOKTemplate = this.getLoginOKTemplate() == null ? DEFAULT_LOGIN_OK_TEMPLATE : this.getLoginOKTemplate();
        String loginFailUrl = this.getLoginFailUrl();
        HashMap<String, Object> args = new HashMap<String, Object>(this.getLoginTemplateArgs());
        args.put("loginUrl", loginUrl);
        args.put("loginOKUrl", loginOKUrl);
        if (loginFailUrl != null) {
            args.put("loginFailUrl", loginFailUrl);
        }
        args.put("loginOKTemplate", loginOKTemplate);
        args.put("loginOKDelay", new Integer(this._delay));
        String scheme = request.getScheme().toLowerCase();
        if (this.isForceHttps() && "http".equals(scheme)) {
            args.put("forceHttps", Boolean.TRUE);
        }
        Executions.createComponents((String)(template == null || template.trim().length() == 0 ? DEFAULT_LOGIN_TEMPLATE : template), null, args);
    }

    public void setLoginTemplateArg(String param, Object value) {
        this._loginTemplateArgs.put(param, value);
    }

    public void removeLoginTemplateArg(String param) {
        this._loginTemplateArgs.remove(param);
    }

    public void setLoginTemplateArgs(Map map) {
        this._loginTemplateArgs = map;
    }

    public Map getLoginTemplateArgs() {
        return this._loginTemplateArgs;
    }

    public void setLoginTemplate(String templateURL) {
        this._loginTemplate = templateURL;
    }

    public String getLoginTemplate() {
        return this._loginTemplate;
    }

    public String getLoginOKTemplate() {
        return this._loginOKTemplate;
    }

    public void setLoginOKTemplate(String loginOKTemplate) {
        if (!StringUtils.hasText((String)loginOKTemplate)) {
            loginOKTemplate = null;
        }
        this._loginOKTemplate = loginOKTemplate;
    }

    public String getLoginOKUrl() {
        return this._loginOKUrl;
    }

    public void setLoginOKUrl(String loginOKUrl) {
        if (!StringUtils.hasText((String)loginOKUrl)) {
            loginOKUrl = null;
        }
        this._loginOKUrl = loginOKUrl;
    }

    public String getLoginFailUrl() {
        return this._loginFailUrl;
    }

    public void setLoginFailUrl(String loginFailUrl) {
        if (!StringUtils.hasText((String)loginFailUrl)) {
            loginFailUrl = null;
        }
        this._loginFailUrl = loginFailUrl;
    }

    public int getLoginOKDelay() {
        return this._delay;
    }

    public void setLoginOKDelay(int seconds) {
        this._delay = seconds;
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        String loginForm = this.getLoginFormUrl();
        return loginForm == null || loginForm.trim().length() == 0 ? "/spring_security_login" : loginForm;
    }
}

