/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.manager;

import com.google.javascript.jscomp.CompilationLevel;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.extensions.processor.css.CssLintProcessor;
import ro.isdc.wro.extensions.processor.css.LessCssProcessor;
import ro.isdc.wro.extensions.processor.css.SassCssProcessor;
import ro.isdc.wro.extensions.processor.css.YUICssCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.BeautifyJsProcessor;
import ro.isdc.wro.extensions.processor.js.CJsonProcessor;
import ro.isdc.wro.extensions.processor.js.CoffeeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.DojoShrinksafeCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.GoogleClosureCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.JsHintProcessor;
import ro.isdc.wro.extensions.processor.js.JsonHPackProcessor;
import ro.isdc.wro.extensions.processor.js.PackerJsProcessor;
import ro.isdc.wro.extensions.processor.js.UglifyJsProcessor;
import ro.isdc.wro.extensions.processor.js.YUIJsCompressorProcessor;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class ExtensionsConfigurableWroManagerFactory
extends ConfigurableWroManagerFactory {
    protected void contributePostProcessors(Map<String, ResourcePostProcessor> map) {
        ExtensionsConfigurableWroManagerFactory.pupulateMapWithExtensionsProcessors(map);
    }

    protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
        ExtensionsConfigurableWroManagerFactory.pupulateMapWithExtensionsProcessors(map);
    }

    public static <T> void pupulateMapWithExtensionsProcessors(Map<String, T> map) {
        Validate.notNull(map);
        map.put("yuiCssMin", new YUICssCompressorProcessor());
        map.put("yuiJsMin", YUIJsCompressorProcessor.noMungeCompressor());
        map.put("yuiJsMinAdvanced", YUIJsCompressorProcessor.doMungeCompressor());
        map.put("dojoShrinksafe", new DojoShrinksafeCompressorProcessor());
        map.put("uglifyJs", new UglifyJsProcessor());
        map.put("beautifyJs", new BeautifyJsProcessor());
        map.put("packerJs", new PackerJsProcessor());
        map.put("lessCss", new LessCssProcessor());
        map.put("sassCss", new SassCssProcessor());
        map.put("googleClosureSimple", new GoogleClosureCompressorProcessor());
        map.put("googleClosureAdvanced", new GoogleClosureCompressorProcessor(CompilationLevel.ADVANCED_OPTIMIZATIONS));
        map.put("coffeeScript", new CoffeeScriptProcessor());
        map.put("cjson-pack", CJsonProcessor.packProcessor());
        map.put("cjson-unpack", CJsonProcessor.unpackProcessor());
        map.put("jsonh-pack", JsonHPackProcessor.packProcessor());
        map.put("jsonh-unpack", JsonHPackProcessor.unpackProcessor());
        map.put("jsHint", new JsHintProcessor());
        map.put("cssLint", new CssLintProcessor());
    }
}

