/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.model.factory;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;

public class JsonModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonModelFactory.class);
    private static final String DEFAULT_FILE_NAME = "wro.json";

    public WroModel create() {
        try {
            Type type = new TypeToken<WroModel>(){}.getType();
            InputStream is = this.getModelResourceAsStream();
            if (is == null) {
                throw new WroRuntimeException("Invalid model stream provided!");
            }
            WroModel model = (WroModel)new Gson().fromJson((Reader)new InputStreamReader(this.getModelResourceAsStream()), type);
            LOG.debug("json model: {}", (Object)model);
            if (model == null) {
                throw new WroRuntimeException("Invalid content provided, cannot build model!");
            }
            return model;
        }
        catch (Exception e) {
            throw new WroRuntimeException("Invalid model found!", (Throwable)e);
        }
    }

    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }
}

