/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DefaultCodingConvention;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class GoogleClosureCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleClosureCompressorProcessor.class);
    public static final String ALIAS_SIMPLE = "googleClosureSimple";
    public static final String ALIAS_ADVANCED = "googleClosureAdvanced";
    private CompilationLevel compilationLevel;
    private CompilerOptions compilerOptions;

    public GoogleClosureCompressorProcessor() {
        this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    }

    public GoogleClosureCompressorProcessor(CompilationLevel compilationLevel) {
        Validate.notNull((Object)compilationLevel);
        this.compilationLevel = compilationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            Compiler.setLoggingLevel((Level)Level.SEVERE);
            Compiler compiler = new Compiler();
            if (this.compilerOptions == null) {
                this.compilerOptions = this.newCompilerOptions();
            }
            this.compilationLevel.setOptionsForCompilationLevel(this.compilerOptions);
            compiler.disableThreads();
            compiler.initOptions(this.compilerOptions);
            JSSourceFile extern = JSSourceFile.fromCode((String)"externs.js", (String)"");
            String fileName = resource == null ? "wro4j-processed-file.js" : resource.getUri();
            JSSourceFile input = JSSourceFile.fromInputStream((String)fileName, (InputStream)new ByteArrayInputStream(content.getBytes(Context.get().getConfig().getEncoding())));
            Result result = compiler.compile(extern, input, this.compilerOptions);
            if (result.success) {
                writer.write(compiler.toSource());
            } else {
                writer.write(content);
            }
        }
        finally {
            LOG.debug("finally");
            reader.close();
            writer.close();
        }
    }

    public GoogleClosureCompressorProcessor setCompilerOptions(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
        return this;
    }

    public GoogleClosureCompressorProcessor setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
        return this;
    }

    protected CompilerOptions newCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new DefaultCodingConvention());
        options.setOutputCharset(Context.get().getConfig().getEncoding());
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        return options;
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

