/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.jshint.JsHint;
import ro.isdc.wro.extensions.processor.support.jshint.JsHintException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@SupportedResourceType(value=ResourceType.JS)
public class JsHintProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JsHintProcessor.class);
    public static final String ALIAS = "jsHint";
    private String[] options;

    public JsHintProcessor setOptions(String[] options) {
        this.options = options;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            this.newJsHint().setOptions(this.options).validate(content);
        }
        catch (JsHintException e) {
            try {
                this.onJsHintException(e, resource);
            }
            catch (Exception ex) {
                throw new WroRuntimeException("", (Throwable)ex);
            }
        }
        catch (WroRuntimeException e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            writer.write(content);
            reader.close();
            writer.close();
        }
    }

    protected JsHint newJsHint() {
        return new JsHint();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected void onJsHintException(JsHintException e, Resource resource) throws Exception {
        LOG.error("The following resource: " + resource + " has " + e.getErrors().size() + " errors.", (Throwable)e);
    }
}

