/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.jsonhpack.JsonHPack;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public abstract class JsonHPackProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHPackProcessor.class);
    public static final String ALIAS_PACK = "jsonh-pack";
    public static final String ALIAS_UNPACK = "jsonh-unpack";
    private JsonHPack engine;

    private JsonHPackProcessor() {
    }

    public static JsonHPackProcessor packProcessor() {
        return new JsonHPackProcessor(){

            @Override
            protected String doProcess(String content) {
                return this.getEngine().pack(content);
            }
        };
    }

    public static JsonHPackProcessor unpackProcessor() {
        return new JsonHPackProcessor(){

            @Override
            protected String doProcess(String content) {
                return this.getEngine().unpack(content);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            writer.write(this.doProcess(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            writer.write(content);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while  applying lessCss processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected abstract String doProcess(String var1);

    protected void onException(WroRuntimeException e) {
    }

    JsonHPack getEngine() {
        if (this.engine == null) {
            this.engine = this.newEngine();
        }
        return this.engine;
    }

    protected JsonHPack newEngine() {
        return new JsonHPack();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

