/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.coffeescript;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class CoffeeScript {
    private static final Logger LOG = LoggerFactory.getLogger(CoffeeScript.class);
    private String[] options;
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getCoffeeScriptAsStream(), "coffee-script.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading init script", ex);
        }
    }

    protected InputStream getCoffeeScriptAsStream() {
        return this.getClass().getResourceAsStream("coffee-script-1.1.3-pre.js");
    }

    public String compile(String data) {
        try {
            StopWatch watch = new StopWatch();
            watch.start("init");
            RhinoScriptBuilder builder = this.initScriptBuilder();
            watch.stop();
            watch.start("compile");
            String compileScript = String.format("CoffeeScript.compile(%s, %s);", WroUtil.toJSMultiLineString((String)data), this.buildOptions());
            String result = (String)builder.evaluate(compileScript, "CoffeeScript.compile");
            watch.stop();
            LOG.debug(watch.prettyPrint());
            return result;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
    }

    private String buildOptions() {
        StringBuffer sb = new StringBuffer("{");
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                sb.append(this.options[i] + ": true");
                if (i >= this.options.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public CoffeeScript setOptions(String ... options) {
        LOG.debug("setOptions: {}", (Object[])options);
        this.options = options == null ? new String[]{} : options;
        return this;
    }
}

