/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.jshint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.jshint.JsHintError;
import ro.isdc.wro.extensions.processor.support.jshint.JsHintException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class JsHint {
    private static final Logger LOG = LoggerFactory.getLogger(JsHint.class);
    private static final String DEFAULT_JSHINT_JS = "jshint.min.js";
    private String[] options;
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getScriptAsStream(), DEFAULT_JSHINT_JS);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Failed reading init script", (Throwable)e);
        }
    }

    protected InputStream getScriptAsStream() {
        return this.getClass().getResourceAsStream(DEFAULT_JSHINT_JS);
    }

    public void validate(String data) throws JsHintException {
        try {
            StopWatch watch = new StopWatch();
            watch.start("init");
            RhinoScriptBuilder builder = this.initScriptBuilder();
            watch.stop();
            watch.start("jsHint");
            LOG.debug("options: {}", (Object)Arrays.toString(this.options));
            String packIt = this.buildJsHintScript(WroUtil.toJSMultiLineString((String)data), this.options);
            boolean valid = Boolean.parseBoolean(builder.evaluate(packIt, "check").toString());
            if (!valid) {
                String json = builder.addJSON().evaluate("JSON.stringify(JSHINT.errors)", "jsHint.errors").toString();
                LOG.debug("json {}", (Object)json);
                Type type = new TypeToken<List<JsHintError>>(){}.getType();
                List errors = (List)new Gson().fromJson(json, type);
                LOG.debug("errors {}", (Object)errors);
                throw new JsHintException().setErrors(errors);
            }
            LOG.debug("result: {}", (Object)valid);
            watch.stop();
            LOG.debug(watch.prettyPrint());
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
    }

    private String buildJsHintScript(String data, String ... options) {
        String script = "JSHINT(" + data + ", " + this.buildOptions(options) + ");";
        LOG.debug("jsHint Script: {}", (Object)script);
        return script;
    }

    protected String buildOptions(String ... options) {
        StringBuffer sb = new StringBuffer("{");
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                String option = options[i];
                if (StringUtils.isEmpty((CharSequence)option)) continue;
                sb.append(this.processSingleOption(option));
                if (i >= options.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        LOG.debug("options: {}", (Object[])options);
        return sb.toString();
    }

    private String processSingleOption(String option) {
        String optionName = option;
        String optionValue = Boolean.TRUE.toString();
        if (option.contains("=")) {
            String[] optionEntry = option.split("=");
            if (optionEntry.length != 2) {
                throw new IllegalArgumentException("Invalid option provided: " + option);
            }
            optionName = optionEntry[0];
            optionValue = option.split("=")[1];
        }
        return String.format("\"%s\": %s", optionName.trim(), optionValue.trim());
    }

    public JsHint setOptions(String ... options) {
        LOG.debug("setOptions: {}", (Object[])options);
        this.options = options == null ? new String[]{} : options;
        return this;
    }
}

