/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.sass;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class SassCss {
    private static final Logger LOG = LoggerFactory.getLogger(SassCss.class);
    private static final String DEFAULT_SASS_JS = "sass-0.5.0.min.js";
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                String scriptInit = "var exports = {};";
                builder = RhinoScriptBuilder.newChain().evaluateChain("var exports = {};", "initSass").evaluateChain(this.getScriptAsStream(), DEFAULT_SASS_JS);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new WroRuntimeException("Failed reading javascript sass.js", (Throwable)ex);
        }
    }

    protected InputStream getScriptAsStream() {
        return this.getClass().getResourceAsStream(DEFAULT_SASS_JS);
    }

    public String process(String data) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("sass rendering");
        try {
            String execute = "exports.render(" + WroUtil.toJSMultiLineString((String)data) + ");";
            Object result = builder.evaluate(execute, "sassRender");
            String string = String.valueOf(result);
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }
}

