/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.uglify;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class UglifyJs {
    private static final Logger LOG = LoggerFactory.getLogger(UglifyJs.class);
    private static final String DEFAULT_UGLIFY_JS = "uglifyJs.min.js";
    private final boolean uglify;
    private String reservedNames;
    private ScriptableObject scope;

    public UglifyJs(boolean uglify) {
        this.uglify = uglify;
    }

    public static UglifyJs uglifyJs() {
        return new UglifyJs(true);
    }

    public static UglifyJs beautifyJs() {
        return new UglifyJs(false);
    }

    public UglifyJs setReservedNames(String reservedNames) {
        this.reservedNames = reservedNames;
        return this;
    }

    private String getReservedNames() {
        return this.reservedNames == null ? "" : this.reservedNames;
    }

    private RhinoScriptBuilder initScriptBuilder() {
        RhinoScriptBuilder builder = null;
        try {
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().addJSON().evaluateChain(this.getClass().getResourceAsStream("init.js"), "initScript").evaluateChain(this.getScriptAsStream(), DEFAULT_UGLIFY_JS);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed initializing js", ex);
        }
    }

    protected InputStream getScriptAsStream() {
        return this.getClass().getResourceAsStream(DEFAULT_UGLIFY_JS);
    }

    public String process(String filename, String code) throws IOException {
        try {
            StopWatch watch = new StopWatch();
            watch.start("init " + filename);
            RhinoScriptBuilder builder = this.initScriptBuilder();
            watch.stop();
            String originalCode = WroUtil.toJSMultiLineString((String)code);
            String invokeScript = String.format(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("invoke.js")), originalCode, this.getReservedNames(), !this.uglify);
            watch.start(this.uglify ? "uglify" : "beautify");
            Object result = builder.evaluate(invokeScript.toString(), "uglifyIt");
            watch.stop();
            LOG.debug(watch.prettyPrint());
            return String.valueOf(result);
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
    }
}

