/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.http.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import ro.isdc.wro.model.resource.Resource;

public class ResourceSerializer
implements JsonSerializer<Resource> {
    private final String basePath;

    public ResourceSerializer(String requestURI) {
        this.basePath = requestURI;
    }

    public JsonElement serialize(Resource resource, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        String uri = resource.getUri();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(resource.getType().toString()));
        jsonObject.add("minimize", (JsonElement)new JsonPrimitive(Boolean.valueOf(resource.isMinimize())));
        jsonObject.add("uri", (JsonElement)new JsonPrimitive(uri));
        jsonObject.add("proxyUri", (JsonElement)new JsonPrimitive(this.getExternalUri(uri)));
        return jsonObject;
    }

    private String getExternalUri(String uri) {
        String result = uri;
        if (!this.isExternal(uri)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.basePath);
            stringBuilder.append("wroResources");
            stringBuilder.append("?id=");
            stringBuilder.append(uri);
            result = stringBuilder.toString();
        }
        return result;
    }

    private boolean isExternal(String uri) {
        return uri.toLowerCase().startsWith("http://") || uri.toLowerCase().startsWith("https://");
    }
}

