/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.sass.SassCss;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.CSS)
public class SassCssProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(SassCssProcessor.class);
    public static final String ALIAS = "sassCss";
    public static final String ALIAS_RUBY = "rubySassCss";
    private ObjectPoolHelper<SassCss> enginePool = new ObjectPoolHelper<SassCss>(new ObjectFactory<SassCss>(){

        public SassCss create() {
            return SassCssProcessor.this.newEngine();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        SassCss engine = this.enginePool.getObject();
        try {
            writer.write(engine.process(content));
        }
        catch (WroRuntimeException e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.error("Exception while applying " + SassCss.class.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            this.onException(e);
            writer.write(content);
        }
        finally {
            reader.close();
            writer.close();
            try {
                this.enginePool.returnObject(engine);
            }
            catch (Exception e) {
                LOG.error("Cannot return lessCss engine to the pool", (Throwable)e);
            }
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected SassCss newEngine() {
        return new SassCss();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

