/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jaxb;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.PippoRuntimeException;

public class JaxbEngine
implements ContentTypeEngine {
    boolean prettyPrint;

    public void init(Application application) {
        this.prettyPrint = application.getPippoSettings().isDev();
    }

    public String getContentType() {
        return "application/xml";
    }

    public String toString(Object object) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)this.prettyPrint);
            StringWriter writer = new StringWriter();
            jaxbMarshaller.marshal(object, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new PippoRuntimeException((Throwable)e, "Failed to serialize '{}' to XML'", new Object[]{object.getClass().getName()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T fromString(String content, Class<T> classOfT) {
        try (StringReader reader = new StringReader(content);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{classOfT});
            XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(xmlStreamReader);
            return (T)object;
        }
        catch (JAXBException | XMLStreamException e) {
            throw new PippoRuntimeException(e, "Failed to deserialize content to '{}'", new Object[]{classOfT.getName()});
        }
    }
}

