/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.pippo.core.util.CookieUtils;
import ro.pippo.session.SessionData;
import ro.pippo.session.SessionStrategy;

public class CookieSessionStrategy
implements SessionStrategy {
    public static final String SESSION_ID_COOKIE_NAME = "SESSIONID";

    @Override
    public String getRequestedSessionId(HttpServletRequest request) {
        Cookie cookie = this.getSessionIdCookie(request);
        return cookie != null ? cookie.getValue() : null;
    }

    @Override
    public void onNewSession(HttpServletRequest request, HttpServletResponse response, SessionData sessionData) {
        String sessionId = sessionData.getId();
        Cookie cookie = this.createSessionIdCookie(request, sessionId);
        response.addCookie(cookie);
    }

    @Override
    public void onInvalidatedSession(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.createSessionIdCookie(request, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    private Cookie createSessionIdCookie(HttpServletRequest request, String sessionId) {
        Cookie cookie = new Cookie(SESSION_ID_COOKIE_NAME, sessionId);
        cookie.setHttpOnly(true);
        cookie.setSecure(request.isSecure());
        cookie.setPath(request.getContextPath() + "/");
        return cookie;
    }

    private Cookie getSessionIdCookie(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)SESSION_ID_COOKIE_NAME);
    }
}

