/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import ro.pippo.session.SessionData;

class PippoHttpSession
implements HttpSession {
    private final SessionData sessionData;
    private final ServletContext servletContext;
    private boolean invalidated;
    private boolean old;

    public PippoHttpSession(SessionData sessionData, ServletContext servletContext) {
        this.sessionData = sessionData;
        this.servletContext = servletContext;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public String getId() {
        return this.sessionData.getId();
    }

    public long getCreationTime() {
        this.checkInvalidated();
        return this.sessionData.getCreationTime();
    }

    public long getLastAccessedTime() {
        this.checkInvalidated();
        return this.sessionData.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.sessionData.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        this.checkInvalidated();
        return this.sessionData.getMaxInactiveInterval();
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        this.checkInvalidated();
        return this.sessionData.getAttribute(name);
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalidated();
        return Collections.enumeration(this.sessionData.getAttributeNames());
    }

    @Deprecated
    public String[] getValueNames() {
        this.checkInvalidated();
        return this.sessionData.getAttributeNames().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalidated();
        this.sessionData.setAttribute(name, value);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkInvalidated();
        this.sessionData.removeAttribute(name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.checkInvalidated();
        this.invalidated = true;
        this.onInvalidate();
    }

    protected void onInvalidate() {
    }

    public boolean isNew() {
        this.checkInvalidated();
        return !this.old;
    }

    public void setNew(boolean isNew) {
        this.old = !isNew;
    }

    private void checkInvalidated() {
        if (this.invalidated) {
            throw new IllegalStateException("The HttpSession has already be invalidated.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PippoHttpSession that = (PippoHttpSession)o;
        return this.sessionData.equals(that.sessionData);
    }

    public int hashCode() {
        return this.sessionData.hashCode();
    }

    public String toString() {
        return "PippoHttpSession{sessionData=" + this.sessionData + '}';
    }
}

