/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.pippo.core.Application;
import ro.pippo.core.Request;
import ro.pippo.core.RequestResponseFactory;
import ro.pippo.core.Response;
import ro.pippo.core.ResponseFinalizeListener;
import ro.pippo.session.SessionHttpServletRequest;
import ro.pippo.session.SessionManager;

public class SessionRequestResponseFactory
extends RequestResponseFactory {
    private final SessionManager sessionManager;

    public SessionRequestResponseFactory(Application application, SessionManager sessionManager) {
        super(application);
        this.sessionManager = sessionManager;
    }

    public Request createRequest(HttpServletRequest httpServletRequest, Response response) {
        final SessionHttpServletRequest sessionHttpServletRequest = new SessionHttpServletRequest(httpServletRequest, this.sessionManager);
        response.getFinalizeListeners().add((Object)new ResponseFinalizeListener(){

            public void onFinalize(Response response) {
                sessionHttpServletRequest.commitSession(response.getHttpServletResponse());
            }
        });
        return super.createRequest((HttpServletRequest)sessionHttpServletRequest, response);
    }

    public Response createResponse(HttpServletResponse httpServletResponse) {
        return super.createResponse(httpServletResponse);
    }
}

