/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SessionData
implements Serializable {
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_SECONDS = 1800;
    private String id = UUID.randomUUID().toString().replace("-", "");
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long creationTime = this.lastAccessedTime = System.currentTimeMillis();
    private long lastAccessedTime;
    private int maxInactiveInterval = 1800;

    public String getId() {
        return this.id;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    boolean isExpired(long now) {
        if (this.maxInactiveInterval < 0) {
            return false;
        }
        return now - TimeUnit.SECONDS.toMillis(this.maxInactiveInterval) >= this.lastAccessedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionData that = (SessionData)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "SessionData{id='" + this.id + '\'' + ", creationTime=" + this.creationTime + ", lastAccessedTime=" + this.lastAccessedTime + ", maxInactiveInterval=" + this.maxInactiveInterval + ", attributes=" + this.attributes + '}';
    }
}

