/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ro.pippo.session.PippoHttpSession;
import ro.pippo.session.SessionData;
import ro.pippo.session.SessionDataStorage;
import ro.pippo.session.SessionManager;
import ro.pippo.session.SessionStrategy;

public class SessionHttpServletRequest
extends HttpServletRequestWrapper {
    private final SessionManager sessionManager;
    private PippoHttpSession currentSession;
    private Boolean requestedSessionIdValid;

    public SessionHttpServletRequest(HttpServletRequest request, SessionManager sessionManager) {
        super(request);
        this.sessionManager = sessionManager;
    }

    public HttpSession getSession(boolean create) {
        SessionData session;
        if (this.currentSession != null) {
            return this.currentSession;
        }
        String requestedSessionId = this.getRequestedSessionId();
        if (requestedSessionId != null && (session = this.getSessionDataStorage().get(requestedSessionId)) != null) {
            this.requestedSessionIdValid = true;
            this.currentSession = this.createSession(session);
            this.currentSession.setNew(false);
            return this.currentSession;
        }
        if (!create) {
            return null;
        }
        session = this.getSessionDataStorage().create();
        this.currentSession = this.createSession(session);
        return this.currentSession;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getRequestedSessionId() {
        return this.getSessionStrategy().getRequestedSessionId((HttpServletRequest)this);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionIdValid == null) {
            String sessionId = this.getRequestedSessionId();
            SessionData sessionData = sessionId != null ? this.getSessionDataStorage().get(sessionId) : null;
            return this.isRequestedSessionIdValid(sessionData);
        }
        return super.isRequestedSessionIdValid();
    }

    private SessionDataStorage getSessionDataStorage() {
        return this.sessionManager.getSessionDataStorage();
    }

    private SessionStrategy getSessionStrategy() {
        return this.sessionManager.getSessionStrategy();
    }

    private boolean isRequestedSessionIdValid(SessionData sessionData) {
        if (this.requestedSessionIdValid == null) {
            this.requestedSessionIdValid = sessionData != null;
        }
        return this.requestedSessionIdValid;
    }

    private PippoHttpSession createSession(SessionData sessionData) {
        return new PippoHttpSession(sessionData, this.getServletContext()){

            @Override
            public void onInvalidate() {
                SessionHttpServletRequest.this.currentSession = null;
                SessionHttpServletRequest.this.getSessionDataStorage().delete(this.getId());
            }
        };
    }

    private boolean isInvalidateClientSession() {
        return this.currentSession == null && this.isRequestedSessionIdValid();
    }

    public void commitSession(HttpServletResponse response) {
        PippoHttpSession wrappedSession = this.currentSession;
        if (wrappedSession == null) {
            if (this.isInvalidateClientSession()) {
                this.getSessionStrategy().onInvalidatedSession((HttpServletRequest)this, response);
            }
        } else {
            SessionData sessionData = wrappedSession.getSessionData();
            this.getSessionDataStorage().save(sessionData);
            if (!this.isRequestedSessionIdValid() || !sessionData.getId().equals(this.getRequestedSessionId())) {
                this.getSessionStrategy().onNewSession((HttpServletRequest)this, response, sessionData);
            }
        }
    }
}

