/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ro.pippo.session.SessionData;

public class DefaultSessionData
implements SessionData {
    public static int DEFAULT_MAX_INACTIVE_INTERVAL_SECONDS = 1800;
    private String id = UUID.randomUUID().toString().replace("-", "");
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long creationTime = this.lastAccessedTime = System.currentTimeMillis();
    private long lastAccessedTime;
    private int maxInactiveInterval = DEFAULT_MAX_INACTIVE_INTERVAL_SECONDS;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <T> T get(String name) {
        return (T)this.attributes.get(name);
    }

    @Override
    public Set<String> getNames() {
        return this.attributes.keySet();
    }

    @Override
    public void put(String name, Object value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    @Override
    public <T> T remove(String name) {
        T t = this.get(name);
        this.attributes.remove(name);
        return t;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    boolean isExpired(long now) {
        if (this.maxInactiveInterval < 0) {
            return false;
        }
        return now - TimeUnit.SECONDS.toMillis(this.maxInactiveInterval) >= this.lastAccessedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionData that = (SessionData)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "SessionData{id='" + this.id + '\'' + ", creationTime=" + this.creationTime + ", lastAccessedTime=" + this.lastAccessedTime + ", maxInactiveInterval=" + this.maxInactiveInterval + ", attributes=" + this.attributes + '}';
    }
}

