/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ro.pippo.session.DefaultSessionData;
import ro.pippo.session.SessionData;
import ro.pippo.session.SessionDataStorage;

public class MemorySessionDataStorage
implements SessionDataStorage {
    private final Map<String, SessionData> sessions = new ConcurrentHashMap<String, SessionData>();

    @Override
    public SessionData create() {
        return new DefaultSessionData();
    }

    @Override
    public void save(SessionData sessionData) {
        this.sessions.put(sessionData.getId(), sessionData);
    }

    @Override
    public SessionData get(String sessionId) {
        SessionData sessionData = this.sessions.get(sessionId);
        if (sessionData == null) {
            return null;
        }
        if (sessionData.isExpired()) {
            this.delete(sessionId);
            return null;
        }
        sessionData.setLastAccessedTime(System.currentTimeMillis());
        return sessionData;
    }

    @Override
    public void delete(String sessionId) {
        this.sessions.remove(sessionId);
    }
}

