/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.DefaultDriverAlivenessChecker;
import ru.stqa.selenium.factory.DefaultLocalDriverProvider;
import ru.stqa.selenium.factory.DriverAlivenessChecker;
import ru.stqa.selenium.factory.LocalDriverProvider;
import ru.stqa.selenium.factory.RemoteDriverProvider;
import ru.stqa.selenium.factory.WebDriverPool;

public abstract class AbstractWebDriverPool
implements WebDriverPool {
    DriverAlivenessChecker alivenessChecker = new DefaultDriverAlivenessChecker();
    private LocalDriverProvider localDriverProvider = new DefaultLocalDriverProvider();
    private RemoteDriverProvider remoteDriverProvider = new RemoteDriverProvider(){};

    protected String createKey(Capabilities capabilities, URL hub) {
        return capabilities.toString() + (hub == null ? "" : ":" + hub.toString());
    }

    protected WebDriver newDriver(URL hub, Capabilities capabilities) {
        return hub == null ? this.localDriverProvider.createDriver(capabilities) : this.remoteDriverProvider.createDriver(hub, capabilities);
    }

    @Override
    public void setDriverAlivenessChecker(DriverAlivenessChecker alivenessChecker) {
        this.alivenessChecker = alivenessChecker;
    }

    @Override
    public void setLocalDriverProvider(LocalDriverProvider localDriverProvider) {
        this.localDriverProvider = localDriverProvider;
    }

    @Override
    public void setRemoteDriverProvider(RemoteDriverProvider remoteDriverProvider) {
        this.remoteDriverProvider = remoteDriverProvider;
    }
}

