/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.DriverCreationError;
import ru.stqa.selenium.factory.LocalDriverProvider;
import ru.stqa.selenium.factory.ReflectionBasedInstanceCreator;

public class DefaultLocalDriverProvider
implements LocalDriverProvider {
    private Map<String, ReflectionBasedInstanceCreator> creators = Stream.of(new Entry("chrome", "org.openqa.selenium.chrome.ChromeDriver"), new Entry("firefox", "org.openqa.selenium.firefox.FirefoxDriver"), new Entry("internet explorer", "org.openqa.selenium.ie.InternetExplorerDriver"), new Entry("MicrosoftEdge", "org.openqa.selenium.edge.EdgeDriver"), new Entry("operablink", "org.openqa.selenium.opera.OperaDriver"), new Entry("opera", "com.opera.core.systems.OperaDriver"), new Entry("safari", "org.openqa.selenium.safari.SafariDriver"), new Entry("phantomjs", "org.openqa.selenium.phantomjs.PhantomJSDriver"), new Entry("htmlunit", "org.openqa.selenium.htmlunit.HtmlUnitDriver")).collect(Collectors.toMap(e -> Entry.access$100(e), e -> new ReflectionBasedInstanceCreator(((Entry)e).className)));

    @Override
    public WebDriver createDriver(Capabilities capabilities) {
        ReflectionBasedInstanceCreator creator = this.creators.get(capabilities.getBrowserName());
        if (creator != null) {
            return creator.createDriver(capabilities);
        }
        throw new DriverCreationError("Can't find local driver provider for capabilities " + capabilities);
    }

    private static class Entry {
        private String browserName;
        private final String className;

        public Entry(String browserName, String className) {
            this.browserName = browserName;
            this.className = className;
        }
    }
}

