/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.AbstractWebDriverPool;

public final class LooseWebDriverPool
extends AbstractWebDriverPool {
    private List<WebDriver> drivers = new ArrayList<WebDriver>();

    public LooseWebDriverPool() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::dismissAll));
    }

    @Override
    public WebDriver getDriver(URL hub, Capabilities capabilities) {
        WebDriver driver = this.newDriver(hub, capabilities);
        this.drivers.add(driver);
        return driver;
    }

    @Override
    public void dismissDriver(WebDriver driver) {
        if (!this.drivers.contains(driver)) {
            throw new Error("The driver is not owned by the factory: " + driver);
        }
        driver.quit();
        this.drivers.remove(driver);
    }

    @Override
    public void dismissAll() {
        for (WebDriver driver : new ArrayList<WebDriver>(this.drivers)) {
            driver.quit();
            this.drivers.remove(driver);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.drivers.isEmpty();
    }
}

