/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.DriverCreationError;

public class ReflectionBasedInstanceCreator {
    private String driverClassName;

    public ReflectionBasedInstanceCreator(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    private Class<? extends WebDriver> getDriverClass() {
        try {
            return Class.forName(this.driverClassName).asSubclass(WebDriver.class);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new DriverCreationError("Driver class not found: " + this.driverClassName, e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new DriverCreationError("Driver class is built for higher Java version: " + this.driverClassName, e);
        }
    }

    public WebDriver createDriver(Capabilities capabilities) {
        return this.callConstructor(this.getDriverClass(), capabilities);
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e1) {
                throw new DriverCreationError(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DriverCreationError(e);
        }
    }
}

