/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.AbstractWebDriverPool;

public final class ThreadLocalSingleWebDriverPool
extends AbstractWebDriverPool {
    private ThreadLocal<WebDriver> tlDriver = new ThreadLocal();
    private Map<WebDriver, String> driverToKeyMap = Collections.synchronizedMap(new HashMap());
    private Map<WebDriver, Thread> driverToThread = Collections.synchronizedMap(new HashMap());

    public ThreadLocalSingleWebDriverPool() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::dismissAll));
    }

    @Override
    public synchronized WebDriver getDriver(URL hub, Capabilities capabilities) {
        this.dismissDriversInFinishedThreads();
        String newKey = this.createKey(capabilities, hub);
        if (this.tlDriver.get() == null) {
            this.createNewDriver(capabilities, hub);
        } else {
            String key = this.driverToKeyMap.get(this.tlDriver.get());
            if (key == null) {
                this.createNewDriver(capabilities, hub);
            } else if (!newKey.equals(key)) {
                this.dismissDriver(this.tlDriver.get());
                this.createNewDriver(capabilities, hub);
            } else if (!this.alivenessChecker.isAlive(this.tlDriver.get())) {
                this.dismissDriver(this.tlDriver.get());
                this.createNewDriver(capabilities, hub);
            }
        }
        return this.tlDriver.get();
    }

    @Override
    public synchronized void dismissDriver(WebDriver driver) {
        this.dismissDriversInFinishedThreads();
        if (this.driverToKeyMap.get(driver) == null) {
            throw new Error("The driver is not owned by the factory: " + driver);
        }
        if (driver != this.tlDriver.get()) {
            throw new Error("The driver does not belong to the current thread: " + driver);
        }
        try {
            driver.quit();
        }
        finally {
            this.driverToKeyMap.remove(driver);
            this.driverToThread.remove(driver);
            this.tlDriver.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dismissDriversInFinishedThreads() {
        List stale = this.driverToThread.entrySet().stream().filter(entry -> !((Thread)entry.getValue()).isAlive()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (WebDriver driver : stale) {
            try {
                driver.quit();
            }
            finally {
                this.driverToKeyMap.remove(driver);
                this.driverToThread.remove(driver);
            }
        }
    }

    @Override
    public synchronized void dismissAll() {
        for (WebDriver driver : new HashSet<WebDriver>(this.driverToKeyMap.keySet())) {
            try {
                driver.quit();
            }
            finally {
                this.driverToKeyMap.remove(driver);
                this.driverToThread.remove(driver);
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.driverToKeyMap.isEmpty();
    }

    private synchronized void createNewDriver(Capabilities capabilities, URL hub) {
        String newKey = this.createKey(capabilities, hub);
        WebDriver driver = this.newDriver(hub, capabilities);
        this.driverToKeyMap.put(driver, newKey);
        this.driverToThread.put(driver, Thread.currentThread());
        this.tlDriver.set(driver);
    }
}

