/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.stqa.selenium.factory.DriverAlivenessChecker;
import ru.stqa.selenium.factory.LocalDriverProvider;
import ru.stqa.selenium.factory.RemoteDriverProvider;
import ru.stqa.selenium.factory.ThreadLocalSingleWebDriverPool;

public interface WebDriverPool {
    public static final WebDriverPool DEFAULT = new ThreadLocalSingleWebDriverPool();

    default public WebDriver getDriver(String browser) {
        return this.getDriver(null, browser);
    }

    default public WebDriver getDriver(URL hub, String browser) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setBrowserName(browser);
        return this.getDriver(hub, (Capabilities)capabilities);
    }

    default public WebDriver getDriver(Capabilities capabilities) {
        return this.getDriver(null, capabilities);
    }

    public WebDriver getDriver(URL var1, Capabilities var2);

    public void dismissDriver(WebDriver var1);

    public void dismissAll();

    public boolean isEmpty();

    public void setDriverAlivenessChecker(DriverAlivenessChecker var1);

    public void setLocalDriverProvider(LocalDriverProvider var1);

    public void setRemoteDriverProvider(RemoteDriverProvider var1);
}

