/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context.container;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class WildcardTypeImpl
implements WildcardType {
    private final Type[] upperBounds;
    private final Type[] lowerBounds;

    public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
        this.upperBounds = Arrays.copyOf(upperBounds, upperBounds.length);
        this.lowerBounds = Arrays.copyOf(lowerBounds, lowerBounds.length);
    }

    @Override
    public Type[] getLowerBounds() {
        return Arrays.copyOf(this.lowerBounds, this.lowerBounds.length);
    }

    @Override
    public Type[] getUpperBounds() {
        return Arrays.copyOf(this.upperBounds, this.upperBounds.length);
    }

    public boolean equals(Object o) {
        boolean res;
        boolean bl = res = this == o;
        if (!res && o instanceof WildcardType) {
            WildcardType that = (WildcardType)o;
            Object[] thatLowerBounds = that.getLowerBounds();
            Object[] thatUpperBounds = that.getUpperBounds();
            res = Arrays.equals(this.lowerBounds, thatLowerBounds) && Arrays.equals(this.upperBounds, thatUpperBounds);
        }
        return res;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.upperBounds);
        result = 31 * result + Arrays.hashCode(this.lowerBounds);
        return result;
    }

    public String toString() {
        return TypeToStringUtils.toStringType(this, Collections.<String, Type>emptyMap());
    }

    public static WildcardTypeImpl upper(Type ... upper) {
        return new WildcardTypeImpl(upper, new Type[0]);
    }

    public static WildcardTypeImpl lower(Type lower) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{lower});
    }
}

