/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueueDao;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class H2QueueDao
implements QueueDao {
    private final Map<QueueLocation, String> enqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> deleteSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> reenqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final QueueTableSchema queueTableSchema;

    public H2QueueDao(@Nonnull JdbcOperations jdbcOperations, @Nonnull QueueTableSchema queueTableSchema) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(Objects.requireNonNull(jdbcOperations, "jdbc template can't be null"));
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema, "table schema can't be null");
    }

    public long enqueue(@Nonnull QueueLocation location, @Nonnull EnqueueParams<String> enqueueParams) {
        Objects.requireNonNull(location, "location can't be null");
        Objects.requireNonNull(enqueueParams, "params can't be null");
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("queueName", (Object)location.getQueueId().asString()).addValue("payload", enqueueParams.getPayload()).addValue("executionDelay", (Object)enqueueParams.getExecutionDelay().getSeconds());
        this.queueTableSchema.getExtFields().forEach(paramName -> params.addValue(paramName, null));
        enqueueParams.getExtData().forEach((arg_0, arg_1) -> ((MapSqlParameterSource)params).addValue(arg_0, arg_1));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(this.enqueueSqlCache.computeIfAbsent(location, this::createEnqueueSql), (SqlParameterSource)params, (KeyHolder)keyHolder, new String[]{this.queueTableSchema.getIdField()});
        Long id = (Long)keyHolder.getKeyAs(Long.class);
        if (id == null) {
            throw new IllegalArgumentException("id can't be null");
        }
        return id;
    }

    public boolean deleteTask(@Nonnull QueueLocation location, long taskId) {
        Objects.requireNonNull(location, "location can't be null");
        int updatedRows = this.jdbcTemplate.update(this.deleteSqlCache.computeIfAbsent(location, this::createDeleteSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()));
        return updatedRows != 0;
    }

    public boolean reenqueue(@Nonnull QueueLocation location, long taskId, @Nonnull Duration executionDelay) {
        Objects.requireNonNull(location, "location can't be null");
        Objects.requireNonNull(executionDelay, "delay can't be null");
        int updatedRows = this.jdbcTemplate.update(this.reenqueueSqlCache.computeIfAbsent(location, this::createReenqueueSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()).addValue("executionDelay", (Object)executionDelay.getSeconds()));
        return updatedRows != 0;
    }

    private String createEnqueueSql(@Nonnull QueueLocation location) {
        return String.format("INSERT INTO %s (   %s    %s,    %s,    %s,    %s,    %s    %s) VALUES (   %s    :queueName,    :payload,    TIMESTAMPADD(SECOND, :executionDelay , NOW()),    0,    0    %s )", location.getTableName(), location.getIdSequence().map(x -> this.queueTableSchema.getIdField()).map(field -> field + ",").orElse(""), this.queueTableSchema.getQueueNameField(), this.queueTableSchema.getPayloadField(), this.queueTableSchema.getNextProcessAtField(), this.queueTableSchema.getReenqueueAttemptField(), this.queueTableSchema.getTotalAttemptField(), this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().collect(Collectors.joining(", ", ", ", "")), location.getIdSequence().map(seq -> String.format(" NEXTVAL('%s'), ", seq)).orElse(""), this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().map(field -> ":" + field).collect(Collectors.joining(", ", ", ", "")));
    }

    private String createDeleteSql(@Nonnull QueueLocation location) {
        return String.format("DELETE FROM %s WHERE %s = :queueName AND %s = :id", location.getTableName(), this.queueTableSchema.getQueueNameField(), this.queueTableSchema.getIdField());
    }

    private String createReenqueueSql(QueueLocation location) {
        return String.format("UPDATE %s SET    %s = TIMESTAMPADD(SECOND, :executionDelay , NOW()),    %s = 0,    %s = %s + 1 WHERE %s = :id AND %s = :queueName", location.getTableName(), this.queueTableSchema.getNextProcessAtField(), this.queueTableSchema.getAttemptField(), this.queueTableSchema.getReenqueueAttemptField(), this.queueTableSchema.getReenqueueAttemptField(), this.queueTableSchema.getIdField(), this.queueTableSchema.getQueueNameField());
    }
}

