/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueueDao;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class MssqlQueueDao
implements QueueDao {
    private final Map<QueueLocation, String> enqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> deleteSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> reenqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    @Nonnull
    private final NamedParameterJdbcTemplate jdbcTemplate;
    @Nonnull
    private final QueueTableSchema queueTableSchema;

    public MssqlQueueDao(@Nonnull JdbcOperations jdbcTemplate, @Nonnull QueueTableSchema queueTableSchema) {
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema);
        this.jdbcTemplate = new NamedParameterJdbcTemplate(Objects.requireNonNull(jdbcTemplate));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public long enqueue(@Nonnull QueueLocation location, @Nonnull EnqueueParams<String> enqueueParams) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(enqueueParams);
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("queueName", (Object)location.getQueueId().asString()).addValue("payload", enqueueParams.getPayload()).addValue("executionDelay", (Object)enqueueParams.getExecutionDelay().getSeconds());
        this.queueTableSchema.getExtFields().forEach(paramName -> params.addValue(paramName, null));
        enqueueParams.getExtData().forEach((arg_0, arg_1) -> ((MapSqlParameterSource)params).addValue(arg_0, arg_1));
        return Objects.requireNonNull((Long)this.jdbcTemplate.queryForObject(this.enqueueSqlCache.computeIfAbsent(location, this::createEnqueueSql), (SqlParameterSource)params, Long.class));
    }

    public boolean deleteTask(@Nonnull QueueLocation location, long taskId) {
        Objects.requireNonNull(location);
        int updatedRows = this.jdbcTemplate.update(this.deleteSqlCache.computeIfAbsent(location, this::createDeleteSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()));
        return updatedRows != 0;
    }

    public boolean reenqueue(@Nonnull QueueLocation location, long taskId, @Nonnull Duration executionDelay) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(executionDelay);
        int updatedRows = this.jdbcTemplate.update(this.reenqueueSqlCache.computeIfAbsent(location, this::createReenqueueSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()).addValue("executionDelay", (Object)executionDelay.getSeconds()));
        return updatedRows != 0;
    }

    private String createEnqueueSql(@Nonnull QueueLocation location) {
        return "INSERT INTO " + location.getTableName() + "(" + location.getIdSequence().map(ignored -> this.queueTableSchema.getIdField() + ",").orElse("") + this.queueTableSchema.getQueueNameField() + "," + this.queueTableSchema.getPayloadField() + "," + this.queueTableSchema.getNextProcessAtField() + "," + this.queueTableSchema.getReenqueueAttemptField() + "," + this.queueTableSchema.getTotalAttemptField() + (this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().collect(Collectors.joining(", ", ", ", ""))) + ") OUTPUT inserted." + this.queueTableSchema.getIdField() + " VALUES (" + location.getIdSequence().map(seq -> "NEXT VALUE FOR " + seq + ", ").orElse("") + ":queueName, :payload, dateadd(ss, :executionDelay, SYSDATETIMEOFFSET()), 0, 0" + (this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().map(field -> ":" + field).collect(Collectors.joining(", ", ", ", ""))) + ")";
    }

    private String createDeleteSql(@Nonnull QueueLocation location) {
        return "DELETE FROM " + location.getTableName() + " WHERE " + this.queueTableSchema.getQueueNameField() + " = :queueName AND " + this.queueTableSchema.getIdField() + " = :id";
    }

    private String createReenqueueSql(@Nonnull QueueLocation location) {
        return "UPDATE " + location.getTableName() + " SET " + this.queueTableSchema.getNextProcessAtField() + " = dateadd(ss, :executionDelay, SYSDATETIMEOFFSET()), " + this.queueTableSchema.getAttemptField() + " = 0, " + this.queueTableSchema.getReenqueueAttemptField() + " = " + this.queueTableSchema.getReenqueueAttemptField() + " + 1 WHERE " + this.queueTableSchema.getIdField() + " = :id AND " + this.queueTableSchema.getQueueNameField() + " = :queueName";
    }
}

