/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.settings.FailRetryType;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class MssqlQueuePickTaskDao
implements QueuePickTaskDao {
    private String pickTaskSql;
    private MapSqlParameterSource pickTaskSqlPlaceholders;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final QueueTableSchema queueTableSchema;

    public MssqlQueuePickTaskDao(@Nonnull JdbcOperations jdbcTemplate, @Nonnull QueueTableSchema queueTableSchema, @Nonnull QueueLocation queueLocation, @Nonnull FailureSettings failureSettings) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(Objects.requireNonNull(jdbcTemplate));
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema);
        this.pickTaskSqlPlaceholders = new MapSqlParameterSource().addValue("queueName", (Object)queueLocation.getQueueId().asString()).addValue("retryInterval", (Object)failureSettings.getRetryInterval().getSeconds());
        this.pickTaskSql = this.createPickTaskSql(queueLocation, failureSettings);
        failureSettings.registerObserver((oldValue, newValue) -> {
            this.pickTaskSql = this.createPickTaskSql(queueLocation, (FailureSettings)newValue);
            this.pickTaskSqlPlaceholders = new MapSqlParameterSource().addValue("queueName", (Object)queueLocation.getQueueId().asString()).addValue("retryInterval", (Object)newValue.getRetryInterval().getSeconds());
        });
    }

    @Nullable
    public TaskRecord pickTask() {
        return (TaskRecord)this.jdbcTemplate.execute(this.pickTaskSql, (SqlParameterSource)this.pickTaskSqlPlaceholders, ps -> {
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    TaskRecord taskRecord = null;
                    return taskRecord;
                }
                LinkedHashMap additionalData = new LinkedHashMap();
                this.queueTableSchema.getExtFields().forEach(key -> {
                    try {
                        additionalData.put(key, rs.getString((String)key));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                TaskRecord taskRecord = TaskRecord.builder().withId(rs.getLong(this.queueTableSchema.getIdField())).withCreatedAt(this.getZonedDateTime(rs, this.queueTableSchema.getCreatedAtField())).withNextProcessAt(this.getZonedDateTime(rs, this.queueTableSchema.getNextProcessAtField())).withPayload(rs.getString(this.queueTableSchema.getPayloadField())).withAttemptsCount(rs.getLong(this.queueTableSchema.getAttemptField())).withReenqueueAttemptsCount(rs.getLong(this.queueTableSchema.getReenqueueAttemptField())).withTotalAttemptsCount(rs.getLong(this.queueTableSchema.getTotalAttemptField())).withExtData(additionalData).build();
                return taskRecord;
            }
        });
    }

    private String createPickTaskSql(@Nonnull QueueLocation location, FailureSettings failureSettings) {
        return "WITH cte AS (SELECT " + this.queueTableSchema.getIdField() + " FROM " + location.getTableName() + " with (readpast, updlock) WHERE " + this.queueTableSchema.getQueueNameField() + " = :queueName   AND " + this.queueTableSchema.getNextProcessAtField() + " <= SYSDATETIMEOFFSET()  ORDER BY " + this.queueTableSchema.getNextProcessAtField() + " ASC offset 0 rows fetch next 1 rows only ) UPDATE " + location.getTableName() + " SET   " + this.queueTableSchema.getNextProcessAtField() + " = " + this.getNextProcessTimeSql(failureSettings.getRetryType(), this.queueTableSchema) + ",   " + this.queueTableSchema.getAttemptField() + " = " + this.queueTableSchema.getAttemptField() + " + 1,   " + this.queueTableSchema.getTotalAttemptField() + " = " + this.queueTableSchema.getTotalAttemptField() + " + 1 OUTPUT inserted." + this.queueTableSchema.getIdField() + ", inserted." + this.queueTableSchema.getPayloadField() + ", inserted." + this.queueTableSchema.getAttemptField() + ", inserted." + this.queueTableSchema.getReenqueueAttemptField() + ", inserted." + this.queueTableSchema.getTotalAttemptField() + ", inserted." + this.queueTableSchema.getCreatedAtField() + ", inserted." + this.queueTableSchema.getNextProcessAtField() + (this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().map(field -> "inserted." + field).collect(Collectors.joining(", ", ", ", ""))) + " FROM cte WHERE " + location.getTableName() + "." + this.queueTableSchema.getIdField() + " = cte." + this.queueTableSchema.getIdField();
    }

    private ZonedDateTime getZonedDateTime(ResultSet rs, String time) throws SQLException {
        return ZonedDateTime.ofInstant(rs.getTimestamp(time).toInstant(), ZoneId.systemDefault());
    }

    @Nonnull
    private String getNextProcessTimeSql(@Nonnull FailRetryType failRetryType, QueueTableSchema queueTableSchema) {
        Objects.requireNonNull(failRetryType);
        switch (failRetryType) {
            case GEOMETRIC_BACKOFF: {
                return "dateadd(ss, power(2, " + queueTableSchema.getAttemptField() + ") * :retryInterval, SYSDATETIMEOFFSET())";
            }
            case ARITHMETIC_BACKOFF: {
                return "dateadd(ss, (1 + (" + queueTableSchema.getAttemptField() + " * 2)) * :retryInterval, SYSDATETIMEOFFSET())";
            }
            case LINEAR_BACKOFF: {
                return "dateadd(ss, :retryInterval, SYSDATETIMEOFFSET())";
            }
        }
        throw new IllegalStateException("unknown retry type: " + failRetryType);
    }
}

