/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.EurekaClientConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.sawano.eureka.legacyregistrar.LegacyClient;
import se.sawano.eureka.legacyregistrar.PropertiesLegacyInstanceConfig;
import se.sawano.java.commons.lang.validate.Validate;

public class EurekaLegacyRegistrarApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final List<LegacyClient> legacyClients = new ArrayList<LegacyClient>();

    public static void main(String[] args) {
        EurekaLegacyRegistrarApplication application = new EurekaLegacyRegistrarApplication();
        application.start();
        try {
            new CountDownLatch(1).await();
        }
        catch (InterruptedException e) {
            application.shutdown();
        }
    }

    public void start() {
        Validate.validState((!this.isStarted() ? 1 : 0) != 0, (String)"Application has already been started");
        this.logger.debug("Starting legacy registrar...");
        this.init();
        this.started.getAndSet(true);
        this.logger.debug("Started successfully");
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void shutdown() {
        Validate.validState((boolean)this.isStarted(), (String)"Application has not been started yet");
        this.logger.debug("Shutting down legacy registrar...");
        this.legacyClients.forEach(this::shutdown);
        this.started.getAndSet(false);
        this.logger.debug("Shut down successfully");
    }

    private void init() {
        List<String> namespaces = this.getNamespaces(this.dynamicPropertyFactory());
        Validate.isFalse((boolean)namespaces.isEmpty(), (String)"No applications configured");
        namespaces.stream().map(this::createLegacyClient).forEach(this.legacyClients::add);
    }

    private DynamicPropertyFactory dynamicPropertyFactory() {
        DynamicStringProperty eurekaPropsFile = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client");
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return DynamicPropertyFactory.getInstance();
    }

    private List<String> getNamespaces(DynamicPropertyFactory instance) {
        String namespace;
        DynamicStringProperty property;
        ArrayList<String> namespaces = new ArrayList<String>();
        String prefix = "eureka.legacy.app";
        int i = 0;
        while ((property = instance.getStringProperty((namespace = "eureka.legacy.app" + i) + ".name", null)).getValue() != null) {
            namespaces.add(namespace);
            ++i;
        }
        return Collections.unmodifiableList(namespaces);
    }

    private LegacyClient createLegacyClient(String namespace) {
        this.logger.debug("Creating legacy instance for namespace: '{}'", (Object)namespace);
        LegacyClient client = new LegacyClient(new PropertiesLegacyInstanceConfig(namespace), (EurekaClientConfig)new DefaultEurekaClientConfig());
        client.init();
        return client;
    }

    private void shutdown(LegacyClient client) {
        try {
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

