/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import se.sawano.eureka.legacyregistrar.LegacyInstanceConfig;
import se.sawano.java.commons.lang.validate.Validate;

public class LegacyClient {
    private DiscoveryClient client;
    private final LegacyInstanceConfig instanceConfig;
    private final EurekaClientConfig clientConfig;

    public LegacyClient(LegacyInstanceConfig instanceConfig, EurekaClientConfig clientConfig) {
        this.instanceConfig = (LegacyInstanceConfig)Validate.notNull((Object)instanceConfig);
        this.clientConfig = (EurekaClientConfig)Validate.notNull((Object)clientConfig);
    }

    public LegacyInstanceConfig instanceConfig() {
        return this.instanceConfig;
    }

    public EurekaClientConfig clientConfig() {
        return this.clientConfig;
    }

    public DiscoveryClient client() {
        return this.client;
    }

    @PostConstruct
    public void init() {
        Validate.validState((this.client == null ? 1 : 0) != 0, (String)"Client has already been initialized");
        ApplicationInfoManager appInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)this.instanceConfig);
        this.client = new DiscoveryClient(appInfoManager, this.clientConfig);
    }

    @PreDestroy
    public void shutdown() {
        Validate.validState((this.client != null ? 1 : 0) != 0, (String)"Client has not been initialized");
        this.client.shutdown();
    }
}

