/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import se.sawano.eureka.legacyregistrar.LegacyInstanceConfig;
import se.sawano.java.commons.lang.validate.Validate;

public class PropertiesLegacyInstanceConfig
implements LegacyInstanceConfig {
    private static final String PROPERTY_HOSTNAME = "hostName";
    private static final String PROPERTY_IP_ADDRESS = "ipAddress";
    private final MyDataCenterInstanceConfig config;

    public PropertiesLegacyInstanceConfig(String namespace) {
        Validate.notEmpty((CharSequence)namespace);
        this.config = new MyDataCenterInstanceConfig(PropertiesLegacyInstanceConfig.normalize(namespace));
    }

    public PropertiesLegacyInstanceConfig(String namespace, DataCenterInfo dataCenterInfo) {
        Validate.notEmpty((CharSequence)namespace);
        Validate.notNull((Object)dataCenterInfo);
        this.config = new MyDataCenterInstanceConfig(PropertiesLegacyInstanceConfig.normalize(namespace), dataCenterInfo);
    }

    private static String normalize(String namespace) {
        String trimmed = namespace.trim();
        if (trimmed.endsWith(".")) {
            return trimmed;
        }
        return trimmed + ".";
    }

    @Override
    public String getHostName(boolean refresh) {
        return this.nonNullProperty(PROPERTY_HOSTNAME);
    }

    @Override
    public String getIpAddress() {
        return this.property(PROPERTY_IP_ADDRESS);
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.config.getDataCenterInfo();
    }

    public boolean isInstanceEnabledOnit() {
        return this.config.isInstanceEnabledOnit();
    }

    public int getNonSecurePort() {
        return this.config.getNonSecurePort();
    }

    public int getSecurePort() {
        return this.config.getSecurePort();
    }

    public boolean isNonSecurePortEnabled() {
        return this.config.isNonSecurePortEnabled();
    }

    public boolean getSecurePortEnabled() {
        return this.config.getSecurePortEnabled();
    }

    public int getLeaseRenewalIntervalInSeconds() {
        return this.config.getLeaseRenewalIntervalInSeconds();
    }

    public int getLeaseExpirationDurationInSeconds() {
        return this.config.getLeaseExpirationDurationInSeconds();
    }

    public String getVirtualHostName() {
        return this.config.getVirtualHostName();
    }

    public String getSecureVirtualHostName() {
        return this.config.getSecureVirtualHostName();
    }

    public String getASGName() {
        return this.config.getASGName();
    }

    public Map<String, String> getMetadataMap() {
        return this.config.getMetadataMap();
    }

    public String getInstanceId() {
        return this.config.getInstanceId();
    }

    public String getAppname() {
        return this.config.getAppname();
    }

    public String getAppGroupName() {
        return this.config.getAppGroupName();
    }

    public String getStatusPageUrlPath() {
        return this.config.getStatusPageUrlPath();
    }

    public String getStatusPageUrl() {
        return this.config.getStatusPageUrl();
    }

    public String getHomePageUrlPath() {
        return this.config.getHomePageUrlPath();
    }

    public String getHomePageUrl() {
        return this.config.getHomePageUrl();
    }

    public String getHealthCheckUrlPath() {
        return this.config.getHealthCheckUrlPath();
    }

    public String getHealthCheckUrl() {
        return this.config.getHealthCheckUrl();
    }

    public String getSecureHealthCheckUrl() {
        return this.config.getSecureHealthCheckUrl();
    }

    public String[] getDefaultAddressResolutionOrder() {
        return this.config.getDefaultAddressResolutionOrder();
    }

    public String getNamespace() {
        return this.config.getNamespace();
    }

    private String nonNullProperty(String property) {
        return (String)Validate.notNull((Object)this.property(property), (String)"Property %s%s cannot be null", (Object[])new Object[]{this.getNamespace(), property});
    }

    private String property(String property) {
        return DynamicPropertyFactory.getInstance().getStringProperty(this.getNamespace() + property, null).get();
    }
}

