/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.boot.context.properties.ConfigurationProperties;
import se.sawano.eureka.legacyregistrar.boot.SpringBootInstanceConfig;
import se.sawano.java.commons.lang.validate.Validate;

@ConfigurationProperties(prefix="eureka.legacy")
public class LegacyInstances {
    @Valid
    private List<SpringBootInstanceConfig> instances = new ArrayList<SpringBootInstanceConfig>();

    public LegacyInstances() {
    }

    LegacyInstances(List<SpringBootInstanceConfig> instances) {
        Validate.noNullElements(instances);
        this.instances.addAll(instances);
    }

    public List<SpringBootInstanceConfig> getInstances() {
        return this.instances;
    }

    public List<SpringBootInstanceConfig> withName(String appName) {
        Validate.notNull((Object)appName);
        return this.instances.stream().filter(conf -> appName.equals(conf.getAppname())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Optional<SpringBootInstanceConfig> withInstanceId(String instanceId) {
        Validate.notNull((Object)instanceId);
        List found = this.instances.stream().filter(conf -> instanceId.equals(conf.getInstanceId())).collect(Collectors.toList());
        if (found.isEmpty()) {
            return Optional.empty();
        }
        Validate.isTrue((1 == found.size() ? 1 : 0) != 0, (String)"Instance id must be unique. Found %d with id '%s'", (Object[])new Object[]{found.size(), instanceId});
        return Optional.of(found.get(0));
    }
}

