/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar.boot;

import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.List;
import java.util.Optional;
import se.sawano.eureka.legacyregistrar.boot.LegacyClientConfig;
import se.sawano.eureka.legacyregistrar.boot.LegacyClientProperties;
import se.sawano.java.commons.lang.validate.Validate;

public class SpringBootClientConfig
implements LegacyClientConfig {
    private final DefaultEurekaClientConfig defaultEurekaClientConfig = new DefaultEurekaClientConfig();
    private final LegacyClientProperties properties;

    public SpringBootClientConfig(LegacyClientProperties properties) {
        this.properties = (LegacyClientProperties)Validate.notNull((Object)properties);
    }

    public int getRegistryFetchIntervalSeconds() {
        return this.defaultEurekaClientConfig.getRegistryFetchIntervalSeconds();
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.defaultEurekaClientConfig.getInstanceInfoReplicationIntervalSeconds();
    }

    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.defaultEurekaClientConfig.getInitialInstanceInfoReplicationIntervalSeconds();
    }

    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.defaultEurekaClientConfig.getEurekaServiceUrlPollIntervalSeconds();
    }

    public String getProxyHost() {
        return this.defaultEurekaClientConfig.getProxyHost();
    }

    public String getProxyPort() {
        return this.defaultEurekaClientConfig.getProxyPort();
    }

    public String getProxyUserName() {
        return this.defaultEurekaClientConfig.getProxyUserName();
    }

    public String getProxyPassword() {
        return this.defaultEurekaClientConfig.getProxyPassword();
    }

    public boolean shouldGZipContent() {
        return this.defaultEurekaClientConfig.shouldGZipContent();
    }

    public int getEurekaServerReadTimeoutSeconds() {
        return this.defaultEurekaClientConfig.getEurekaServerReadTimeoutSeconds();
    }

    public int getEurekaServerConnectTimeoutSeconds() {
        return this.defaultEurekaClientConfig.getEurekaServerConnectTimeoutSeconds();
    }

    public String getBackupRegistryImpl() {
        return this.defaultEurekaClientConfig.getBackupRegistryImpl();
    }

    public int getEurekaServerTotalConnections() {
        return this.defaultEurekaClientConfig.getEurekaServerTotalConnections();
    }

    public int getEurekaServerTotalConnectionsPerHost() {
        return this.defaultEurekaClientConfig.getEurekaServerTotalConnectionsPerHost();
    }

    public String getEurekaServerURLContext() {
        return this.defaultEurekaClientConfig.getEurekaServerURLContext();
    }

    public String getEurekaServerPort() {
        return this.defaultEurekaClientConfig.getEurekaServerPort();
    }

    public String getEurekaServerDNSName() {
        return this.defaultEurekaClientConfig.getEurekaServerDNSName();
    }

    @Override
    public boolean shouldUseDnsForFetchingServiceUrls() {
        return Optional.ofNullable(this.properties.isShouldUseDns()).orElseGet(() -> ((DefaultEurekaClientConfig)this.defaultEurekaClientConfig).shouldUseDnsForFetchingServiceUrls());
    }

    public boolean shouldRegisterWithEureka() {
        return this.defaultEurekaClientConfig.shouldRegisterWithEureka();
    }

    @Override
    public boolean shouldPreferSameZoneEureka() {
        return Optional.ofNullable(this.properties.isPreferSameZone()).orElseGet(() -> ((DefaultEurekaClientConfig)this.defaultEurekaClientConfig).shouldPreferSameZoneEureka());
    }

    public boolean allowRedirects() {
        return this.defaultEurekaClientConfig.allowRedirects();
    }

    public boolean shouldLogDeltaDiff() {
        return this.defaultEurekaClientConfig.shouldLogDeltaDiff();
    }

    public boolean shouldDisableDelta() {
        return this.defaultEurekaClientConfig.shouldDisableDelta();
    }

    public String fetchRegistryForRemoteRegions() {
        return this.defaultEurekaClientConfig.fetchRegistryForRemoteRegions();
    }

    public String getRegion() {
        return this.defaultEurekaClientConfig.getRegion();
    }

    public String[] getAvailabilityZones(String region) {
        return this.defaultEurekaClientConfig.getAvailabilityZones(region);
    }

    @Override
    public List<String> getEurekaServerServiceUrls(String myZone) {
        return Optional.ofNullable(this.properties.getServiceUrlDefault()).orElseGet(() -> this.defaultEurekaClientConfig.getEurekaServerServiceUrls(myZone));
    }

    public boolean shouldFilterOnlyUpInstances() {
        return this.defaultEurekaClientConfig.shouldFilterOnlyUpInstances();
    }

    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.defaultEurekaClientConfig.getEurekaConnectionIdleTimeoutSeconds();
    }

    public boolean shouldFetchRegistry() {
        return this.defaultEurekaClientConfig.shouldFetchRegistry();
    }

    public String getRegistryRefreshSingleVipAddress() {
        return this.defaultEurekaClientConfig.getRegistryRefreshSingleVipAddress();
    }

    public int getHeartbeatExecutorThreadPoolSize() {
        return this.defaultEurekaClientConfig.getHeartbeatExecutorThreadPoolSize();
    }

    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.defaultEurekaClientConfig.getHeartbeatExecutorExponentialBackOffBound();
    }

    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.defaultEurekaClientConfig.getCacheRefreshExecutorThreadPoolSize();
    }

    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.defaultEurekaClientConfig.getCacheRefreshExecutorExponentialBackOffBound();
    }

    public String getDollarReplacement() {
        return this.defaultEurekaClientConfig.getDollarReplacement();
    }

    public String getEscapeCharReplacement() {
        return this.defaultEurekaClientConfig.getEscapeCharReplacement();
    }

    public boolean shouldOnDemandUpdateStatusChange() {
        return this.defaultEurekaClientConfig.shouldOnDemandUpdateStatusChange();
    }

    public String getEncoderName() {
        return this.defaultEurekaClientConfig.getEncoderName();
    }

    @Override
    public String getDecoderName() {
        return Optional.ofNullable(this.properties.getDecoderName()).orElseGet(() -> ((DefaultEurekaClientConfig)this.defaultEurekaClientConfig).getDecoderName());
    }

    public String getClientDataAccept() {
        return this.defaultEurekaClientConfig.getClientDataAccept();
    }

    public String getExperimental(String name) {
        return this.defaultEurekaClientConfig.getExperimental(name);
    }

    public EurekaTransportConfig getTransportConfig() {
        return this.defaultEurekaClientConfig.getTransportConfig();
    }
}

