/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.client;

import smartrics.rest.client.RestData;

public class RestRequest
extends RestData {
    private static final String FILE = "file";
    private String fileName;
    private String multipartFileName;
    private String multipartFileParameterName = "file";
    private String query;
    private Method method;
    private boolean followRedirect = true;
    private boolean resourceUriEscaped = false;

    public Method getMethod() {
        return this.method;
    }

    public RestRequest setMethod(Method method) {
        this.method = method;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public RestRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMultipartFileName() {
        return this.multipartFileName;
    }

    public String getMultipartFileParameterName() {
        return this.multipartFileParameterName;
    }

    public RestRequest setMultipartFileParameterName(String multipartFileParameterName) {
        this.multipartFileParameterName = multipartFileParameterName;
        return this;
    }

    public RestRequest setMultipartFileName(String multipartFileName) {
        this.multipartFileName = multipartFileName;
        return this;
    }

    public RestRequest setFollowRedirect(boolean v) {
        this.followRedirect = v;
        return this;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public RestRequest setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public boolean isValid() {
        return this.getMethod() != null && this.getResource() != null;
    }

    public boolean isResourceUriEscaped() {
        return this.resourceUriEscaped;
    }

    public RestRequest setResourceUriEscaped(boolean escaped) {
        this.resourceUriEscaped = escaped;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getMethod() != null) {
            builder.append(this.getMethod().toString()).append(" ");
        }
        if (this.getResource() != null) {
            builder.append(this.getResource());
        }
        if (this.getQuery() != null) {
            builder.append("?").append(this.getQuery());
        }
        builder.append(LINE_SEPARATOR);
        builder.append(super.toString());
        return builder.toString();
    }

    public static enum Method {
        Get,
        Post,
        Put,
        Delete,
        Head,
        Options,
        Trace;

    }
}

