/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartrics.rest.client.RestClient;
import smartrics.rest.client.RestData;
import smartrics.rest.client.RestMultipart;
import smartrics.rest.client.RestRequest;
import smartrics.rest.client.RestResponse;

public class RestClientImpl
implements RestClient {
    private static Logger LOG = LoggerFactory.getLogger(RestClientImpl.class);
    private final HttpClient client;
    private String baseUrl;

    public RestClientImpl(HttpClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Null HttpClient instance");
        }
        this.client = client;
    }

    @Override
    public void setBaseUrl(String bUrl) {
        this.baseUrl = bUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public RestResponse execute(RestRequest request) {
        return this.execute(this.getBaseUrl(), request);
    }

    @Override
    public RestResponse execute(String hostAddr, RestRequest request) {
        if (request == null || !request.isValid()) {
            throw new IllegalArgumentException("Invalid request " + request);
        }
        if (request.getTransactionId() == null) {
            request.setTransactionId(System.currentTimeMillis());
        }
        LOG.debug("request: {}", (Object)request);
        HttpMethod m = this.createHttpClientMethod(request);
        this.configureHttpMethod(m, hostAddr, request);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.info("Http Request URI : {}", (Object)m.getURI());
            }
            catch (URIException e) {
                LOG.error("Error URIException in debug : " + e.getMessage(), (Throwable)e);
            }
            LOG.debug("Http Request Method Class : {} ", m.getClass());
            LOG.debug("Http Request Header : {} ", (Object)Arrays.toString(m.getRequestHeaders()));
            if (m instanceof EntityEnclosingMethod) {
                try {
                    ByteArrayOutputStream requestOut = new ByteArrayOutputStream();
                    ((EntityEnclosingMethod)m).getRequestEntity().writeRequest((OutputStream)requestOut);
                    LOG.debug("Http Request Body : {}", (Object)requestOut.toString());
                }
                catch (IOException e) {
                    LOG.error("Error in reading request body in debug : " + e.getMessage(), (Throwable)e);
                }
            }
        }
        RestResponse resp = new RestResponse();
        resp.setTransactionId(request.getTransactionId());
        resp.setResource(request.getResource());
        try {
            this.client.executeMethod(m);
            for (Header h : m.getResponseHeaders()) {
                resp.addHeader(h.getName(), h.getValue());
            }
            resp.setStatusCode(m.getStatusCode());
            resp.setStatusText(m.getStatusText());
            resp.setRawBody(m.getResponseBody());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Http Request Path : {}", (Object)m.getPath());
                LOG.debug("Http Request Header : {} ", (Object)Arrays.toString(m.getRequestHeaders()));
                LOG.debug("Http Response Status : {}", (Object)m.getStatusLine());
                LOG.debug("Http Response Body : {}", (Object)m.getResponseBodyAsString());
            }
        }
        catch (HttpException e) {
            String message = "Http call failed for protocol failure";
            throw new IllegalStateException(message, e);
        }
        catch (IOException e) {
            String message = "Http call failed for IO failure";
            throw new IllegalStateException(message, e);
        }
        finally {
            m.releaseConnection();
        }
        LOG.debug("response: {}", (Object)resp);
        return resp;
    }

    protected void configureHttpMethod(HttpMethod m, String hostAddr, final RestRequest request) {
        this.addHeaders(m, request);
        this.setUri(m, hostAddr, request);
        m.setQueryString(request.getQuery());
        if (m instanceof EntityEnclosingMethod) {
            Map<String, RestMultipart> multipartFiles;
            RequestEntity requestEntity = null;
            String fileName = request.getFileName();
            requestEntity = fileName != null ? this.configureFileUpload(fileName) : ((multipartFiles = request.getMultipartFileNames()) != null && !multipartFiles.isEmpty() ? this.configureMultipartFileUpload(m, request, requestEntity, multipartFiles) : new RequestEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                public void writeRequest(OutputStream out) throws IOException {
                    PrintWriter printer = new PrintWriter(out);
                    printer.print(request.getBody());
                    printer.flush();
                }

                public long getContentLength() {
                    return request.getBody().getBytes().length;
                }

                public String getContentType() {
                    List<RestData.Header> values = request.getHeader("Content-Type");
                    String v = "text/xml";
                    if (values.size() != 0) {
                        v = values.get(0).getValue();
                    }
                    return v;
                }
            });
            ((EntityEnclosingMethod)m).setRequestEntity(requestEntity);
        } else {
            m.setFollowRedirects(request.isFollowRedirect());
        }
    }

    private RequestEntity configureMultipartFileUpload(HttpMethod m, RestRequest request, RequestEntity requestEntity, Map<String, RestMultipart> multipartFiles) {
        MultipartRequestEntity multipartRequestEntity = null;
        Object fileName = null;
        ArrayList<Part> fileParts = new ArrayList<Part>(multipartFiles.size());
        for (Map.Entry<String, RestMultipart> multipartFile : multipartFiles.entrySet()) {
            Part filePart = this.createMultipart(multipartFile.getKey(), multipartFile.getValue());
            fileParts.add(filePart);
        }
        Part[] parts = fileParts.toArray(new Part[fileParts.size()]);
        multipartRequestEntity = new MultipartRequestEntity(parts, ((EntityEnclosingMethod)m).getParams());
        return multipartRequestEntity;
    }

    private Part createMultipart(String fileParamName, RestMultipart restMultipart) {
        RestMultipart.RestMultipartType type = restMultipart.getType();
        switch (type) {
            case FILE: {
                String fileName = null;
                try {
                    fileName = restMultipart.getValue();
                    File file = new File(fileName);
                    FilePart filePart = new FilePart(fileParamName, file, restMultipart.getContentType(), restMultipart.getCharset());
                    LOG.info("Configure Multipart file upload paramName={} :  ContentType={} for  file={} ", (Object[])new String[]{fileParamName, restMultipart.getContentType(), fileName});
                    return filePart;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("File not found: " + fileName, e);
                }
            }
            case STRING: {
                StringPart stringPart = new StringPart(fileParamName, restMultipart.getValue(), restMultipart.getCharset());
                stringPart.setContentType(restMultipart.getContentType());
                LOG.info("Configure Multipart String upload paramName={} :  ContentType={} ", (Object)fileParamName, (Object)stringPart.getContentType());
                return stringPart;
            }
        }
        throw new IllegalArgumentException("Unknonw Multipart Type : " + (Object)((Object)type));
    }

    private RequestEntity configureFileUpload(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + fileName);
        }
        return new FileRequestEntity(file, "application/octet-stream");
    }

    public String getContentType(RestRequest request) {
        List<RestData.Header> values = request.getHeader("Content-Type");
        String v = "text/xml";
        if (values.size() != 0) {
            v = values.get(0).getValue();
        }
        return v;
    }

    private void setUri(HttpMethod m, String hostAddr, RestRequest request) {
        String host;
        String string = host = hostAddr == null ? this.client.getHostConfiguration().getHost() : hostAddr;
        if (host == null) {
            throw new IllegalStateException("hostAddress is null: please config httpClient host configuration or pass a valid host address or config a baseUrl on this client");
        }
        String uriString = host + request.getResource();
        boolean escaped = request.isResourceUriEscaped();
        try {
            m.setURI(this.createUri(uriString, escaped));
        }
        catch (URIException e) {
            throw new IllegalStateException("Problem when building URI: " + uriString, e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Building URI with null string", e);
        }
    }

    protected URI createUri(String uriString, boolean escaped) throws URIException {
        return new URI(uriString, escaped);
    }

    protected String getMethodClassnameFromMethodName(String mName) {
        return String.format("org.apache.commons.httpclient.methods.%sMethod", mName);
    }

    protected HttpMethod createHttpClientMethod(RestRequest request) {
        String mName = request.getMethod().toString();
        String className = this.getMethodClassnameFromMethodName(mName);
        try {
            Class<?> clazz = Class.forName(className);
            if (className.endsWith("TraceMethod")) {
                return (HttpMethod)clazz.getConstructor(String.class).newInstance("http://dummy.com");
            }
            return (HttpMethod)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(className + " not found: you may be using a too old or " + "too new version of HttpClient", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("An object of type " + className + " cannot be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The default ctor for type " + className + " cannot be accessed", e);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception when instantiating: " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The ctor with String.class arg for type " + className + " cannot be invoked", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("The ctor with String.class arg for type " + className + " doesn't exist", e);
        }
    }

    private void addHeaders(HttpMethod m, RestRequest request) {
        for (RestData.Header h : request.getHeaders()) {
            m.addRequestHeader(h.getName(), h.getValue());
        }
    }
}

